-------------------------------------------------------------------------------
--                                                                           --
--            XPATH IN ADA Copyright (C) 2003, McKae Technologies            --
--                                                                           --
--  XPath in  Ada (XIA) is  free software;  you can redistribute  it and/or  --
--  modify it under terms of the GNU General Public License as published by  --
--  the Free Software Foundation; either version 3, or (at your option) any  --
--  later version.  GNAT is distributed in the hope that it will be useful,  --
--  but  WITHOUT  ANY  WARRANTY;  without  even  the  implied  warranty  of  --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--                                                                           --
--  As  a special  exception under  Section  7 of  GPL version  3, you  are  --
--  granted  additional permissions  described in  the GCC  Runtime Library  --
--  Exception, version 3.1, as published by the Free Software Foundation.    --
--                                                                           --
--  You should have received a copy of the GNU General Public License and a  --
--  copy of the GCC Runtime Library  Exception along with this program; see  --
--  the  files  COPYING3 and  COPYING.RUNTIME  respectively.   If not,  see  --
--  <http://www.gnu.org/licenses/>.                                          --
--                                                                           --
--  XIA is maintained at https://github.com/simonjwright/xia                 --
--                                                                           --
-------------------------------------------------------------------------------

--  Append a node to an XMLAda DOM node list
procedure Dom.Core.Append_Node
  (List : in out Node_List;
   --  list to which to append the node

   N : Node
   --  Node to append
  ) is
   Old : Node_Array_Access := List.Items;
begin
   if Old = null or else Old'Last = List.Last then
      List.Items := new Node_Array (0 .. (List.Last + 10) * 3);
      if Old /= null then
         List.Items (0 .. List.Last) := Old.all;
         Free (Old);
      end if;
   end if;
   List.Last := List.Last + 1;
   List.Items (List.Last) := N;
   null;
end Dom.Core.Append_Node;
