package jiracmd

import "github.com/go-jira/jira/jiracli"

func RegisterAllCommands() {
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "acknowledge", Entry: CmdTransitionRegistry("acknowledge"), Aliases: []string{"ack"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "assign", Entry: CmdAssignRegistry(), Aliases: []string{"give"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "attach create", Entry: CmdAttachCreateRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "attach get", Entry: CmdAttachGetRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "attach list", Entry: CmdAttachListRegistry(), Aliases: []string{"ls"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "attach remove", Entry: CmdAttachRemoveRegistry(), Aliases: []string{"rm"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "backlog", Entry: CmdTransitionRegistry("Backlog")})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "block", Entry: CmdBlockRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "browse", Entry: CmdBrowseRegistry(), Aliases: []string{"b"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "close", Entry: CmdTransitionRegistry("close")})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "comment", Entry: CmdCommentRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "component add", Entry: CmdComponentAddRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "components", Entry: CmdComponentsRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "create", Entry: CmdCreateRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "createmeta", Entry: CmdCreateMetaRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "done", Entry: CmdTransitionRegistry("Done")})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "dup", Entry: CmdDupRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "edit", Entry: CmdEditRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "editmeta", Entry: CmdEditMetaRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "epic add", Entry: CmdEpicAddRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "epic create", Entry: CmdEpicCreateRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "epic list", Entry: CmdEpicListRegistry(), Aliases: []string{"ls"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "epic remove", Entry: CmdEpicRemoveRegistry(), Aliases: []string{"rm"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "export-templates", Entry: CmdExportTemplatesRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "fields", Entry: CmdFieldsRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "in-progress", Entry: CmdTransitionRegistry("Progress"), Aliases: []string{"prog", "progress"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "issuelink", Entry: CmdIssueLinkRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "issuelinktypes", Entry: CmdIssueLinkTypesRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "issuetypes", Entry: CmdIssueTypesRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "labels add", Entry: CmdLabelsAddRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "labels remove", Entry: CmdLabelsRemoveRegistry(), Aliases: []string{"rm"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "labels set", Entry: CmdLabelsSetRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "list", Entry: CmdListRegistry(), Aliases: []string{"ls"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "login", Entry: CmdLoginRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "logout", Entry: CmdLogoutRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "rank", Entry: CmdRankRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "reopen", Entry: CmdTransitionRegistry("reopen")})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "request", Entry: CmdRequestRegistry(), Aliases: []string{"req"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "resolve", Entry: CmdTransitionRegistry("resolve")})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "start", Entry: CmdTransitionRegistry("start")})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "stop", Entry: CmdTransitionRegistry("stop")})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "subtask", Entry: CmdSubtaskRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "take", Entry: CmdTakeRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "todo", Entry: CmdTransitionRegistry("To Do")})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "transition", Entry: CmdTransitionRegistry(""), Aliases: []string{"trans"}})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "transitions", Entry: CmdTransitionsRegistry("transitions")})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "transmeta", Entry: CmdTransitionsRegistry("debug")})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "unassign", Entry: CmdUnassignRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "unexport-templates", Entry: CmdUnexportTemplatesRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "view", Entry: CmdViewRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "vote", Entry: CmdVoteRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "watch", Entry: CmdWatchRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "worklog add", Entry: CmdWorklogAddRegistry()})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "worklog list", Entry: CmdWorklogListRegistry(), Default: true})
	jiracli.RegisterCommand(jiracli.CommandRegistry{Command: "session", Entry: CmdSessionRegistry()})
}
