---
description: |
    The Packer Alicloud Import post-processor takes a RAW or VHD artifact from
    various builders and imports it to an Alicloud customized image list.
layout: docs
page_title: 'Alicloud Import Post-Processor'
sidebar_current: 'docs-post-processors-alicloud-import'
---

# Alicloud Import Post-Processor

Type: `alicloud-import`

The Packer Alicloud Import post-processor takes a RAW or VHD artifact from
various builders and imports it to an Alicloud ECS Image.

## How Does it Work?

The import process operates by making a temporary copy of the RAW or VHD to an
OSS bucket, and calling an import task in ECS on the RAW or VHD file. Once
completed, an Alicloud ECS Image is returned. The temporary RAW or VHD copy in
OSS can be discarded after the import is complete.

## Configuration

There are some configuration options available for the post-processor. There
are two categories: required and optional parameters.

### Required:

-   `access_key` (string) - This is the Alicloud access key. It must be
    provided, but it can also be sourced from the `ALICLOUD_ACCESS_KEY`
    environment variable.

-   `secret_key` (string) - This is the Alicloud secret key. It must be
    provided, but it can also be sourced from the `ALICLOUD_SECRET_KEY`
    environment variable.

-   `region` (string) - This is the Alicloud region. It must be provided, but
    it can also be sourced from the `ALICLOUD_REGION` environment variables.

-   `image_name` (string) - The name of the user-defined image, \[2, 128\]
    English or Chinese characters. It must begin with an uppercase/lowercase
    letter or a Chinese character, and may contain numbers, `_` or `-`. It
    cannot begin with `http://` or `https://`

-   `oss_bucket_name` (string) - The name of the OSS bucket where the RAW or
    VHD file will be copied to for import. If the Bucket isn't exist,
    post-process will create it for you.

-   `image_os_type` (string) - Type of the OS linux/windows

-   `image_platform` (string) - platform such `CentOS`

-   `image_architecture` (string) - Platform type of the image system: `i386` or
    `x86_64`

-   `format` (string) - The format of the image for import, now alicloud only
    support RAW and VHD.

### Optional:

-   `oss_key_name` (string) - The name of the object key in `oss_bucket_name`
    where the RAW or VHD file will be copied to for import.

-   `skip_clean` (boolean) - Whether we should skip removing the RAW or VHD
    file uploaded to OSS after the import process has completed. `true` means
    that we should leave it in the OSS bucket, `false` means to clean it out.
    Defaults to `false`.

-   `image_description` (string) - The description of the image, with a length
    limit of 0 to 256 characters. Leaving it blank means null, which is the
    default value. It cannot begin with `http://` or `https://`.

-   `image_force_delete` (boolean) - If this value is true, when the target
    image name is duplicated with an existing image, it will delete the
    existing image and then create the target image, otherwise, the creation
    will fail. The default value is false.

-   `image_system_size` (number) - Size of the system disk, in GB, values
    range:
    -   cloud - 5 \~ 2000
    -   cloud\_efficiency - 20 \~ 2048
    -   cloud\_ssd - 20 \~ 2048

## Basic Example

Here is a basic example. This assumes that the builder has produced a RAW
artifact. The user must have the role `AliyunECSImageImportDefaultRole` with
`AliyunECSImageImportRolePolicy`, post-process will automatically configure the
role and policy for you if you have the privilege, otherwise, you have to ask
the administrator configure for you in advance.

``` json
"post-processors":[
    {
      "access_key":"{{user `access_key`}}",
      "secret_key":"{{user `secret_key`}}",
      "type":"alicloud-import",
      "oss_bucket_name": "packer",
      "image_name": "packer_import",
      "image_os_type": "linux",
      "image_platform": "CentOS",
      "image_architecture": "x86_64",
      "image_system_size": "40",
      "region":"cn-beijing"
    }
  ]
```

This will take the RAW generated by a builder and upload it to OSS. In this
case, an existing bucket called `packer` in the `cn-beijing` region will be
where the copy is placed.

Once uploaded, the import process will start, creating an Alicloud ECS image in
the `cn-beijing` region with the name you specified in template file.
