# IPS 高级用法示例

<!-- TOC -->
* [IPS 高级用法示例](#ips-高级用法示例)
  * [减少字段以压缩数据库体积](#减少字段以压缩数据库体积)
  * [制作自定义数据库](#制作自定义数据库)
<!-- TOC -->

## 减少字段以压缩数据库体积

商业数据库通常包含大量详细信息，如经纬度、时区和邮编等，其中高精度的经纬度信息尤其会占用较多空间。

然而，用户在实际应用中并不总是需要所有数据。根据业务需求裁剪不必要的字段可以有效减小数据库体积。

例如，[埃文科技](https://www.ipplus360.com)的商用 IPv4 数据库文件大小超过 600MB，这在分发和使用时带来了不便。

如果您在使用中，仅需要国家、省份和城市信息，可以使用以下命令来重打包数据库：

```shell
# 将 ipv4.awdb 重打包为 ipv4_new.awdb，仅包含国家、省份、城市和运营商字段
ips pack -i ./ipv4.awdb -f country,province,city,isp -o ./ipv4_new.ipdb
```

这样重新打包后的数据库文件大约为 120MB；我们仍然可以进一步减少数据量，例如，如果在中国地区需要细化到城市和运营商级别的数据，而海外地区仅需国家级别信息，可以使用以下命令来重打包：

```shell
# 中国地区包含国家、省份、城市和运营商信息，海外地区仅包含国家信息
ips pack -i ./ipv4.awdb -f 'country,province,city,isp|country=!中国:country' -o ./ipv4_new.ipdb
```

使用此命令重新打包后的数据库体积降至约 7.7MB，相较原文件缩减了大约 98% 的体积。这显著优化了数据库文件的分发效率，并降低了运行时的内存占用。

## 制作自定义数据库

IPS 允许用户转储数据库文件至文本格式，便于进行自定义修改。随后，用户可将修改后的文本文件重新打包成新的数据库文件，从而创建自定义数据库。

例如，若需判断某个 IP 是否属于自己公司，可以将公司的 IP 段以约定的格式写入文本文件，然后将其打包成数据库文件，实现自定义查询数据库。

由于 IP 数据库文件查询通常采用前缀树搜索算法，自定义数据库查询效率通常高于文本文件查询，并且分发起来更为便捷。

```shell
# 转存数据库为文本文件
ips dump -i ./ipv4.awdb -o ./ipv4.txt

# 将自定义文本文件打包成数据库文件
ips pack -i ./custom.txt -o ./custom.ipdb
```

一些流量分流工具会使用 `mmdb` 格式的数据库文件来进行流量分流，IPS 也支持生成 `mmdb` 格式的数据库文件。

如果您的分流工具仅需 `geoname_id` 来获取国家信息，您甚至可以使用 `--output-option` 参数来移除 `mmdb` 文件中的多语言翻译数据，以进一步压缩文件大小。

```shell
# 将自定义文本文件打包成 mmdb 格式的数据库文件
ips pack -i ./custom.txt -o ./custom.mmdb

# 移除 mmdb 数据库文件中的多语言翻译数据
ips pack -i ./custom.txt -o ./custom.mmdb --output-option "select_languages=-"
```
