---
title: "Compiler Error CS0571 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0571"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0571"
ms.assetid: 72a97e9c-3c78-47de-b477-dbd2c953d95d
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0571
'function' : cannot explicitly call operator or accessor  
  
 Certain operators have internal names. For example, **op_Increment** is the internal name of the ++ operator. You should not use or explicitly call such method names.  
  
 The following sample generates CS0571:  
  
```  
// CS0571.cs  
public class MyClass  
{  
   public static MyClass operator ++ (MyClass c)  
   {  
      return null;  
   }  
  
   public static int prop  
   {  
      get  
      {  
         return 1;  
      }  
      set  
      {  
      }  
   }  
  
   public static void Main()  
   {  
      op_Increment(null);   // CS0571  
      // use the increment operator as follows  
      // MyClass x = new MyClass();  
      // x++;  
  
      set_prop(1);      // CS0571  
      // try the following line instead  
      // prop = 1;  
   }  
}  
```