---
title: "Compiler Error CS1674 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1674"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1674"
ms.assetid: 7a018629-35f4-406a-8a5f-1cee7343da6d
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1674
'T': type used in a using statement must be implicitly convertible to 'System.IDisposable'  
  
 The [using Statement](../../../csharp/language-reference/keywords/using-statement.md) is intended to be used to ensure the disposal of an object at the end of the `using` block, thus, only types which are disposable may be used in such a statement. For example, value types are not disposable, and type parameters which are not constrained to be classes may not be assumed to be disposable.  
  
## Example  
 The following sample generates CS1674.  
  
```  
// CS1674.cs  
class C  
{  
   public static void Main()  
   {  
      int a = 0;  
      a++;  
  
      using (a) {}   // CS1674  
   }  
}  
```  
  
## Example  
 The following sample generates CS1674.  
  
```  
// CS1674_b.cs  
using System;  
class C {  
   public void Test() {  
      using (C c = new C()) {}   // CS1674  
   }  
}  
  
// OK  
class D : IDisposable {  
   void IDisposable.Dispose() {}  
   public void Dispose() {}  
  
   public static void Main() {  
      using (D d = new D()) {}  
   }  
}  
```  
  
## Example  
 The following case illustrates the need for a class type constraint to guarantee that an unknown type parameter is disposable. The following sample generates CS1674.  
  
```  
// CS1674_c.cs  
// compile with: /target:library  
using System;  
public class C<T>  
// Add a class type constraint that specifies a disposable class.  
// Uncomment the following line to resolve.  
// public class C<T> where T : IDisposable  
{  
   public void F(T t)  
   {  
      using (t) {}   // CS1674  
   }  
}  
```