---
title: "Compiler Error CS1919 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1919"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1919"
ms.assetid: 5d1e468b-ddec-4edd-a8b1-9c65c2332778
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1919
Unsafe type 'type name' cannot be used in object creation.  
  
 The `new` operator creates objects only on the managed heap. However, you can create objects in unmanaged memory indirectly by using the interoperability capabilities of the language to call native methods that return pointers.  
  
## To correct this error  
  
1.  Use a safe type in the new object creation expression. For example, use `char` or `int` instead of `char*` or `int*`.  
  
2.  If you must create objects in unmanaged memory, use a Win32 or COM method or else write your own function in C or C++ and call it from C#.  
  
## Example  
 The following example generates CS1919 because a pointer type is unsafe:  
  
```  
// cs1919.cs  
// Compile with: /unsafe  
unsafe public class C  
{  
    public static int Main()  
    {  
        var col1 = new int* { }; // CS1919  
        var col2 = new char* { }; // CS1919  
        return 1;  
    }  
}  
```  
  
## See Also  
 [Interoperability](../../../csharp/programming-guide/interop/index.md)