---
title: "C# Compiler Errors | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
dev_langs: 
  - "CSharp"
  - "CSharp"
helpviewer_keywords: 
  - "C# language, compiler errors"
  - "Visual C# compiler, errors"
  - "errors [C#]"
ms.assetid: 57262ab1-6c50-4f9c-81ad-9fba48477416
caps.latest.revision: 23
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# C# Compiler Errors
Some C# compiler errors have corresponding topics that explain why the error is generated, and, in some cases, how to fix the error. Use one of the following steps to see whether help is available for a particular error message.  
  
-   Find the error number (for example, CS0029) in the [Output Window](https://docs.microsoft.com/visualstudio/ide/reference/output-window), and then search for it on MSDN.  
  
-   Choose the error number (for example, CS0029) in the [Output Window](https://docs.microsoft.com/visualstudio/ide/reference/output-window), and then choose the F1 key.  
  
-   In the Index, enter the error number in the **Look for** box.  
  
 If none of these steps leads to information about your error, go to the end of this page, and send feedback that includes the number or text of the error.  
  
 For information about how to configure error and warning options in C#, see [Build Page, Project Designer (C#)](https://docs.microsoft.com/visualstudio/ide/reference/build-page-project-designer-csharp).  
  
[!INCLUDE[note_settings_general](../../../csharp/language-reference/compiler-messages/includes/note_settings_general_md.md)]  
  
## See Also  
 [C# Compiler Options](../../../csharp/language-reference/compiler-options/index.md)   
 [Sorry, we don't have specifics on this C# error](../../../csharp/misc/sorry-we-don-t-have-specifics-on-this-csharp-error.md)   
 [Build Page, Project Designer (C#)](https://docs.microsoft.com/visualstudio/ide/reference/build-page-project-designer-csharp)   
 [/warn (C# Compiler Options)](../../../csharp/language-reference/compiler-options/warn-compiler-option.md)   
 [/nowarn (C# Compiler Options)](../../../csharp/language-reference/compiler-options/nowarn-compiler-option.md)