---
title: "Compiler Error CS0254 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0254"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0254"
ms.assetid: 85b2ab1e-0011-4f1d-9181-76b9c9f3d914
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0254
The right hand side of a fixed statement assignment may not be a cast expression  
  
 The right side of a [fixed](../../csharp/language-reference/keywords/fixed-statement.md) expression may not use a cast. For more information, see [Unsafe Code and Pointers](../../csharp/programming-guide/unsafe-code-pointers/index.md).  
  
 The following sample generates CS0254:  
  
```  
// CS0254.cs  
// compile with: /unsafe  
class Point  
{  
   public uint x, y;  
}  
  
class FixedTest  
{  
   unsafe static void SquarePtrParam (int* p)  
   {  
      *p *= *p;  
   }  
  
   unsafe public static void Main()  
   {  
      Point pt = new Point();  
      pt.x = 5;  
      pt.y = 6;  
  
      fixed (int* p = (int*)&pt.x)   // CS0254  
      // try the following line instead  
      // fixed (uint* p = &pt.x)  
      {  
         SquarePtrParam ((int*)p);  
      }  
   }  
}  
```