---
title: "Compiler Error CS0573 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0573"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0573"
ms.assetid: 10ef9625-44f1-4936-ada3-56938357aa01
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0573
'field declaration' : cannot have instance field initializers in structs  
  
 You cannot initialize an instance field of a [struct](../../csharp/language-reference/keywords/struct.md). Fields of value types will be initialized to their default values, and reference-type fields will be initialized to `null`.  
  
## Example  
 The following sample generates CS0573:  
  
```  
// CS0573.cs  
namespace x  
{  
    public class clx  
    {  
        public static void Main()  
        {  
        }  
    }  
  
    public struct cly  
    {  
        clx a = new clx();   // CS0573  
        // clx a;            // OK  
        int i = 7;           // CS0573  
        // int i;            // OK  
    }  
}  
```