---
title: "Compiler Error CS0822 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0822"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0822"
ms.assetid: 519091be-2332-4df4-acd9-e3b633966b3d
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0822
Implicitly typed locals cannot be const  
  
 Implicitly typed local variables are only necessary for storing anonymous types. In all other cases they are just a convenience. If the value of the variable never changes, just give it an explicit type. Attempting to use the `readonly` modifier with an implicitly typed local will generate CS0106.  
  
## To correct this error  
  
1.  If you require the variable to be constant or `readonly`, give it an explicit type.  
  
## Example  
 The following code generates CS0822:  
  
```  
// cs0822.cs  
class A  
{  
  
    public static int Main()  
    {  
        const var x = 0; // CS0822.cs  
        return -1;  
    }  
}  
```  
  
## See Also  
 [Implicitly Typed Local Variables](../../csharp/programming-guide/classes-and-structs/implicitly-typed-local-variables.md)