---
title: "Compiler Warning (level 2) CS1698 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1698"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1698"
ms.assetid: 65cac5d0-e045-40f9-911c-1bf50e710b18
caps.latest.revision: 20
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 2) CS1698
Circular assembly reference 'AssemblyName1' does not match the output assembly name 'AssemblyName2'. Try adding a reference to 'AssemblyName1' or changing the output assembly name to match.  
  
 CS1698 occurs when an assembly reference is incorrect. This can happen if a referenced assembly is recompiled. To resolve, do not replace an assembly that itself is a dependency of an assembly you are referencing.  
  
## Example  
  
```  
// CS1698_a.cs  
// compile with: /target:library /keyfile:mykey.snk  
[assembly:System.Reflection.AssemblyVersion("2")]  
public class CS1698_a {}  
```  
  
## Example  
  
```  
// CS1698_b.cs  
// compile with: /target:library /reference:CS1698_a.dll /keyfile:mykey.snk  
public class CS1698_b : CS1698_a {}  
```  
  
## Example  
 The following sample generates CS1698.  
  
```  
// CS1698_c.cs  
// compile with: /target:library /out:cs1698_a.dll /reference:cs1698_b.dll /keyfile:mykey.snk  
// CS1698 expected  
[assembly:System.Reflection.AssemblyVersion("3")]  
public class CS1698_c : CS1698_b {}  
public class CS1698_a {}  
  
```