---
title: "Advanced Query Techniques (LINQ to XML) (C#) | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
ms.assetid: 028d978e-215b-4d50-ba70-adce0659386d
caps.latest.revision: 3
author: "BillWagner"
ms.author: "wiwagn"

---
# Advanced Query Techniques (LINQ to XML) (C#)
This section provides examples of more advanced [!INCLUDE[sqltecxlinq](../../../../csharp/programming-guide/concepts/linq/includes/sqltecxlinq_md.md)] query techniques.  
  
## In This Section  
  
|Topic|Description|  
|-----------|-----------------|  
|[How to: Join Two Collections (LINQ to XML) (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-join-two-collections-linq-to-xml.md)|Shows how to use the `Join` clause to take advantage of relationships in XML data.|  
|[How to: Create Hierarchy Using Grouping (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-create-hierarchy-using-grouping.md)|Shows how to group data, and then generate XML based on the grouping.|  
|[How to: Query LINQ to XML Using XPath (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-query-linq-to-xml-using-xpath.md)|Shows how to retrieve collections based on XPath queries.|  
|[How to: Write a LINQ to XML Axis Method (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-write-a-linq-to-xml-axis-method.md)|Shows how to write a [!INCLUDE[sqltecxlinq](../../../../csharp/programming-guide/concepts/linq/includes/sqltecxlinq_md.md)] axis method.|  
|[How to: Perform Streaming Transformations of Text to XML (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-perform-streaming-transformations-of-text-to-xml.md)|Shows how to transform very large text files into XML while maintaining a small memory footprint.|  
|[How to: List All Nodes in a Tree (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-list-all-nodes-in-a-tree.md)|Presents a utility method that lists all nodes in an XML tree. This is useful for debugging code that modifies an XML tree.|  
|[How to: Retrieve Paragraphs from an Office Open XML Document (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-retrieve-paragraphs-from-an-office-open-xml-document.md)|Presents code that opens an Office Open XML Document, retrieves the paragraphs in a collection of XElement objects, the text of the paragraphs, and the style of the paragraphs.|  
|[How to: Modify an Office Open XML Document (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-modify-an-office-open-xml-document.md)|Presents code that opens, modifies, and saves an Office Open XML Document.|  
|[How to: Populate an XML Tree from the File System (C#)](../../../../csharp/programming-guide/concepts/linq/how-to-populate-an-xml-tree-from-the-file-system.md)|Presents code that creates an XML tree from the file system.|  
  
## See Also  
 [Querying XML Trees (C#)](../../../../csharp/programming-guide/concepts/linq/querying-xml-trees.md)