---
title: Basic string operations
description: Basic string operations
keywords: .NET, .NET Core
author: stevehoag
ms.author: shoag
ms.date: 07/26/2016
ms.topic: article
ms.prod: .net
ms.technology: dotnet-standard
ms.devlang: dotnet
ms.assetid: 9658098d-de60-4868-ba5b-0c278748a90f
---

# Basic string operations

Applications often respond to users by constructing messages based on user input. For example, it is not uncommon for Web sites to respond to a newly logged-on user with a specialized greeting that includes the user's name. Several methods in the [System.String](xref:System.String) and [System.Text.StringBuilder](xref:System.Text.StringBuilder) classes allow you to dynamically construct custom strings to display in your user interface. These methods also help you perform a number of basic string operations like creating new strings from arrays of bytes, comparing the values of strings, and modifying existing strings.

## In This Section

[Creating new strings](creating-new.md) - Describes basic ways to convert objects into strings and to combine strings.

[Trimming and removing characters](trimming.md) - Describes how to trim or remove characters in a string. 

[Padding strings](padding.md) - Describes how to insert characters or empty spaces into a string.

[Comparing strings](comparing.md) - Describes how to compare the contents of two or more strings.

[Changing case](changing-case.md) - Describes how to change the case of characters within a string.

[Using the StringBuilder class](stringbuilder.md) - Describes how to create and modify dynamic string objects with the [StringBuilder](xref:System.Text.StringBuilder) class.

[How to: Perform basic string manipulations](basic-manipulations.md) - Demonstrates the use of basic string operations.

## Related Sections

[Type conversion](type-conversion.md) - Describes how to convert from one type to another.

[Formatting types](formatting-types.md) - Describes how to format strings using the string format specifiers.


