---
title: "Leading &#39;.&#39; or &#39;!&#39; cannot appear in a constant expression | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc30995"
  - "bc30995"
helpviewer_keywords: 
  - "BC30995"
ms.assetid: eed62684-66db-4fdb-9da7-f1407a55b172
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Leading &#39;.&#39; or &#39;!&#39; cannot appear in a constant expression
Member access (.) and dictionary member access (!) require an expression specifying the element that contains the member most of the time, including constant expressions. The following declaration is not valid.  
  
```  
' Not valid.  
Const c As String = .name  
```  
  
 **Error ID:** BC30995  
  
## To correct this error  
  
-   Specify the instance that contains the member that you want to access.  
  
## See Also  
 [Object Initializers: Named and Anonymous Types](../../visual-basic/programming-guide/language-features/objects-and-classes/object-initializers-named-and-anonymous-types.md)   
 [How to: Declare an Instance of an Anonymous Type (Visual Basic)](http://msdn.microsoft.com/en-us/119f616c-9bcd-4731-ac00-4285be5959f7)   
 [Const Statement](../../visual-basic/language-reference/statements/const-statement.md)