---
title: "&#39;Custom&#39; modifier is not valid on events declared in interfaces | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc31121"
  - "vbc31121"
helpviewer_keywords: 
  - "BC31121"
ms.assetid: b5687034-a2b2-4961-88b7-0ba73023573e
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;Custom&#39; modifier is not valid on events declared in interfaces
A custom event cannot be declared in an interface because a custom event must provide an implementation of its `AddHandler`, `RemoverHandler`, and `RaiseEvent` methods.  
  
 The `Custom` keyword can be used in a derived class that implements the event.  
  
 **Error ID:** BC31121  
  
## To correct this error  
  
-   Remove the `Custom` keyword from the event declaration in the interface.  
  
## Example  
 This example shows how to implement an event declared in an interface as a custom event.  
  
 [!code-vb[VbVbalrEventError#3](../../visual-basic/language-reference/error-messages/codesnippet/VisualBasic/bc31121_1.vb)]  
  
## See Also  
 [Custom - delete](http://msdn.microsoft.com/en-us/dc62be07-c896-4866-a533-982a661d143f)   
 [Event Statement](../../visual-basic/language-reference/statements/event-statement.md)   
 [Delegate Statement](../../visual-basic/language-reference/statements/delegate-statement.md)   
 [Class Statement](../../visual-basic/language-reference/statements/class-statement.md)   
 [Interface Statement](../../visual-basic/language-reference/statements/interface-statement.md)   
 [Events](../../visual-basic/programming-guide/language-features/events/index.md)