---
title: "Expression of type &#39;&lt;typename1&gt;&#39; can never be of type &#39;&lt;typename2&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc31430"
  - "bc31430"
helpviewer_keywords: 
  - "BC31430"
ms.assetid: 1d527033-3f6f-4945-b1d3-5ef59a1e1b53
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Expression of type &#39;&lt;typename1&gt;&#39; can never be of type &#39;&lt;typename2&gt;&#39;
A `TypeOf`...`Is` expression tests an object reference variable to a data type that it cannot hold.  
  
 In some cases the compiler can determine that a `TypeOf`...`Is` test can only fail, for example if there is no inheritance relationship between two classes.  
  
 The following code can generate this error.  
  
 `Dim refVar as System.Windows.Forms.Form`  
  
 `If TypeOf refVar Is System.Array`  
  
 `End If`  
  
 Because <xref:System.Windows.Forms.Form> and <xref:System.Array> are totally unrelated types, the compiler can determine that the `TypeOf`...`Is` expression returns `False` for any value of `refVar`.  
  
 **Error ID:** BC31430  
  
## To correct this error  
  
-   Test the variable for a realistic data type, or remove the `TypeOf`...`Is` test altogether.  
  
## See Also  
 [TypeOf Operator](../../visual-basic/language-reference/operators/typeof-operator.md)   
 [How to: Determine What Type an Object Variable Refers To](../../visual-basic/programming-guide/language-features/variables/how-to-determine-what-type-an-object-variable-refers-to.md)