---
title: "Operators cannot be declared &#39;&lt;keyword&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc33013"
  - "bc33013"
helpviewer_keywords: 
  - "BC33013"
ms.assetid: bfd805f4-e30e-4553-9cb7-2690595f0480
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Operators cannot be declared &#39;&lt;keyword&gt;&#39;
An operator is declared with a keyword that is not valid for operator definitions.  
  
 Every operator must be declared as both [Public](../../visual-basic/language-reference/modifiers/public.md) and [Shared](../../visual-basic/language-reference/modifiers/shared.md). In addition, a conversion operator must be declared with either [Widening](../../visual-basic/language-reference/modifiers/widening.md) or [Narrowing](../../visual-basic/language-reference/modifiers/narrowing.md), but not both. An operator definition can optionally include the [Overloads](../../visual-basic/language-reference/modifiers/overloads.md) or [Shadows](../../visual-basic/language-reference/modifiers/shadows.md) keywords. No other keywords are permitted in an [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md).  
  
 **Error ID:** BC33013  
  
## To correct this error  
  
-   Remove the invalid keyword from the operator definition.  
  
## See Also  
 [Operator Procedures](../../visual-basic/programming-guide/language-features/procedures/operator-procedures.md)   
 [How to: Define an Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-an-operator.md)   
 [How to: Define a Conversion Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-a-conversion-operator.md)