# [Procedures in Visual Basic](index.md)
## [How to: Create a Procedure](how-to-create-a-procedure.md)
## [Sub Procedures](sub-procedures.md)
### [How to: Call a Procedure that Does Not Return a Value](how-to-call-a-procedure-that-does-not-return-a-value.md)
### [How to: Call an Event Handler](how-to-call-an-event-handler.md)
## [Function Procedures](function-procedures.md)
### [How to: Create a Procedure that Returns a Value](how-to-create-a-procedure-that-returns-a-value.md)
### [How to: Return a Value from a Procedure](how-to-return-a-value-from-a-procedure.md)
### [How to: Call a Procedure That Returns a Value](how-to-call-a-procedure-that-returns-a-value.md)
## [Property Procedures](property-procedures.md)
### [Auto-Implemented Properties](auto-implemented-properties.md)
### [Differences Between Properties and Variables](differences-between-properties-and-variables.md)
### [How to: Create a Property](how-to-create-a-property.md)
### [How to: Declare a Property with Mixed Access Levels](how-to-declare-a-property-with-mixed-access-levels.md)
### [How to: Call a Property Procedure](how-to-call-a-property-procedure.md)
### [How to: Declare and Call a Default Property](how-to-declare-and-call-a-default-property.md)
### [How to: Put a Value in a Property](how-to-put-a-value-in-a-property.md)
### [How to: Get a Value from a Property](how-to-get-a-value-from-a-property.md)
## [Operator Procedures](operator-procedures.md)
### [How to: Define an Operator](how-to-define-an-operator.md)
### [How to: Define a Conversion Operator](how-to-define-a-conversion-operator.md)
### [How to: Call an Operator Procedure](how-to-call-an-operator-procedure.md)
### [How to: Use a Class that Defines Operators](how-to-use-a-class-that-defines-operators.md)
## [Procedure Parameters and Arguments](procedure-parameters-and-arguments.md)
### [Differences Between Parameters and Arguments](differences-between-parameters-and-arguments.md)
### [How to: Define a Parameter for a Procedure](how-to-define-a-parameter-for-a-procedure.md)
### [How to: Pass Arguments to a Procedure](how-to-pass-arguments-to-a-procedure.md)
### [Passing Arguments by Value and by Reference](passing-arguments-by-value-and-by-reference.md)
#### [Differences Between Modifiable and Nonmodifiable Arguments](differences-between-modifiable-and-nonmodifiable-arguments.md)
#### [Differences Between Passing an Argument By Value and By Reference](differences-between-passing-an-argument-by-value-and-by-reference.md)
#### [How to: Change the Value of a Procedure Argument](how-to-change-the-value-of-a-procedure-argument.md)
#### [How to: Protect a Procedure Argument Against Value Changes](how-to-protect-a-procedure-argument-against-value-changes.md)
#### [How to: Force an Argument to Be Passed by Value](how-to-force-an-argument-to-be-passed-by-value.md)
### [Passing Arguments by Position and by Name](passing-arguments-by-position-and-by-name.md)
### [Optional Parameters](optional-parameters.md)
### [Parameter Arrays](parameter-arrays.md)
## [Recursive Procedures](recursive-procedures.md)
## [Procedure Overloading](procedure-overloading.md)
### [How to: Define Multiple Versions of a Procedure](how-to-define-multiple-versions-of-a-procedure.md)
### [How to: Call an Overloaded Procedure](how-to-call-an-overloaded-procedure.md)
### [How to: Overload a Procedure that Takes Optional Parameters](how-to-overload-a-procedure-that-takes-optional-parameters.md)
### [How to: Overload a Procedure that Takes an Indefinite Number of Parameters](how-to-overload-a-procedure-that-takes-an-indefinite-number-of-parameters.md)
### [Considerations in Overloading Procedures](considerations-in-overloading-procedures.md)
### [Overload Resolution](overload-resolution.md)
## [Troubleshooting Procedures](troubleshooting-procedures.md)
## [Extension Methods](extension-methods.md)
### [How to: Write an Extension Method](how-to-write-an-extension-method.md)
### [How to: Call an Extension Method](how-to-call-an-extension-method.md)
## [Lambda Expressions](lambda-expressions.md)
### [How to: Create a Lambda Expression](how-to-create-a-lambda-expression.md)
## [Partial Methods](partial-methods.md)
