// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.

using Microsoft.VisualStudio.Shell;

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.Build.Tasks.CodeAnalysis",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.CSharp",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.CSharp.EditorFeatures",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.CSharp.Features",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.CSharp.Workspaces",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.EditorFeatures",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.EditorFeatures.Text",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.Features",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.VisualBasic",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.VisualBasic.EditorFeatures",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.VisualBasic.Features",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.VisualBasic.Workspaces",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.Workspaces.Desktop",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.CodeAnalysis.Workspaces",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.VisualStudio.LanguageServices",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.VisualStudio.LanguageServices.Implementation",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.VisualStudio.LanguageServices.VisualBasic",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.VisualStudio.LanguageServices.CSharp",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "Microsoft.VisualStudio.LanguageServices.SolutionExplorer",
    OldVersionLowerBound = Constants.OldVersionLowerBound,
    OldVersionUpperBound = Constants.OldVersionUpperBound,
    NewVersion = Constants.NewVersion,
    PublicKeyToken = Constants.PublicKeyToken,
    GenerateCodeBase = false)]

[assembly: ProvideBindingRedirection(
    AssemblyName = "System.Reflection.Metadata",
    OldVersionLowerBound = "1.0.0.0",
    OldVersionUpperBound = "1.0.99.0",
    NewVersion = "1.1.0.0",
    PublicKeyToken = "b03f5f7f11d50a3a",
    GenerateCodeBase = false)]

internal class Constants
{
    public const string OldVersionLowerBound = "0.7.0.0";
    public const string OldVersionUpperBound = "1.1.0.0";

#if OFFICIAL_BUILD
    // If this is an official build we want to generate binding
    // redirects from our old versions to the release version 
    public const string NewVersion = "1.1.0.0";
#else
    // Non-official builds get redirects to local 42.42.42.42,
    // which will only be built locally
    public const string NewVersion = "42.42.42.42";
#endif

    public const string PublicKeyToken = "31BF3856AD364E35";
}
