<?php
/**
 * Items class
 *
 * @package   MyAAC
 * @author    Gesior <jerzyskalski@wp.pl>
 * @author    Slawkens <slawkens@gmail.com>
 * @copyright 2019 MyAAC
 * @link      https://my-aac.org
 */

namespace MyAAC;

use MyAAC\Cache\PHP as CachePHP;
use MyAAC\Models\Spell;

class Items
{
	private static $error = '';
	public static $items;

	public static function loadFromXML($show = false)
	{
		$file_path = config('data_path') . 'items/items.xml';
		if (!file_exists($file_path)) {
			self::$error = 'Cannot load file ' . $file_path;
			return false;
		}

		$xml = new \DOMDocument;
		$xml->load($file_path);

		$items = array();
		foreach ($xml->getElementsByTagName('item') as $item) {
			if ($item->getAttribute('fromid')) {
				for ($id = $item->getAttribute('fromid'); $id <= $item->getAttribute('toid'); $id++) {
					$tmp = self::parseNode($id, $item, $show);
					$items[$tmp['id']] = $tmp['content'];
				}
			} else {
				$tmp = self::parseNode($item->getAttribute('id'), $item, $show);
				$items[$tmp['id']] = $tmp['content'];
			}
		}

		$cache_php = new CachePHP(config('cache_prefix'), CACHE . 'persistent/');
		$cache_php->set('items', $items, 5 * 365 * 24 * 60 * 60);
		return true;
	}

	public static function parseNode($id, $node, $show = false) {
		$name = $node->getAttribute('name');
		$article = $node->getAttribute('article');
		$plural = $node->getAttribute('plural');

		$attributes = array();
		foreach($node->getElementsByTagName('attribute') as $attr) {
			$attributes[strtolower($attr->getAttribute('key'))] = $attr->getAttribute('value');
		}

		return array('id' => $id, 'content' => array('article' => $article, 'name' => $name, 'plural' => $plural, 'attributes' => $attributes));
	}

	public static function getError() {
		return self::$error;
	}

	public static function load() {
		if(self::$items) {
			return;
		}

		$cache_php = new CachePHP(config('cache_prefix'), CACHE . 'persistent/');
		self::$items = $cache_php->get('items');
	}

	public static function get($id) {
		self::load();
		return isset(self::$items[$id]) ? self::$items[$id] : [];
	}

	public static function getDescription($id, $count = 1) {
		$item = self::get($id);

		$attr = $item['attributes'];
		$s = '';
		if(!empty($item['name'])) {
			if($count > 1) {
				if($attr['showcount']) {
					$s .= $count . ' ';
				}

				if(!empty($item['plural'])) {
					$s .= $item['plural'];
				}
				else if((int)$attr['showcount'] == 0) {
					$s .= $item['name'];
				}
				else {
					$s .= $item['name'] . 's';
				}
			}
			else {
				if(!empty($item['aticle'])) {
					$s .= $item['article'] . ' ';
				}

				$s .= $item['name'];
			}
		}
		else
			$s .= 'an item of type ' . $item['id'];

		if(isset($attr['type']) && strtolower($attr['type']) == 'rune') {
			$item = Spell::where('item_id', $id)->first();
			if($item) {
				if($item->level > 0 && $item->maglevel > 0) {
					$s .= '. ' . ($count > 1 ? "They" : "It") . ' can only be used by ';
				}

				$configVocations = config('vocations');
				if(!empty(trim($item->vocations))) {
					$vocations = json_decode($item->vocations);
					if(count($vocations) > 0) {
						foreach($vocations as $voc => $show) {
							$vocations[$configVocations[$voc]] = $show;
						}
					}
				}
				else {
					$s .= 'players';
				}

				$s .= ' with';

			}
		}
		return $s;
	}
}
