/*******************************************************************************
 * Copyright (c) 2015 Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.acceleo.query.tests.qmodel.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.acceleo.query.tests.qmodel.util.QmodelAdapterFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support
 * Viewers. The adapters generated by this factory convert EMF adapter
 * notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The
 * adapters also support Eclipse property sheets. Note that most of the adapters
 * are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class QmodelItemProviderAdapterFactory extends QmodelAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this
	 * adapter factory. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement
	 * {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by
	 * {@link #isFactoryForType isFactoryForType}. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public QmodelItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.Query} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected QueryItemProvider queryItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.Query}. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createQueryAdapter() {
		if (queryItemProvider == null) {
			queryItemProvider = new QueryItemProvider(this);
		}

		return queryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.EObjectVariable} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EObjectVariableItemProvider eObjectVariableItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.EObjectVariable}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEObjectVariableAdapter() {
		if (eObjectVariableItemProvider == null) {
			eObjectVariableItemProvider = new EObjectVariableItemProvider(this);
		}

		return eObjectVariableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.ListResult} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ListResultItemProvider listResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.ListResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createListResultAdapter() {
		if (listResultItemProvider == null) {
			listResultItemProvider = new ListResultItemProvider(this);
		}

		return listResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.SetResult} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SetResultItemProvider setResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.SetResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSetResultAdapter() {
		if (setResultItemProvider == null) {
			setResultItemProvider = new SetResultItemProvider(this);
		}

		return setResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.Queries} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected QueriesItemProvider queriesItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.Queries}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createQueriesAdapter() {
		if (queriesItemProvider == null) {
			queriesItemProvider = new QueriesItemProvider(this);
		}

		return queriesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.ModelElement} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ModelElementItemProvider modelElementItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.ModelElement}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createModelElementAdapter() {
		if (modelElementItemProvider == null) {
			modelElementItemProvider = new ModelElementItemProvider(this);
		}

		return modelElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.QueryEvaluationResultExpectation}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected QueryEvaluationResultExpectationItemProvider queryEvaluationResultExpectationItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.QueryEvaluationResultExpectation}
	 * . <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createQueryEvaluationResultExpectationAdapter() {
		if (queryEvaluationResultExpectationItemProvider == null) {
			queryEvaluationResultExpectationItemProvider = new QueryEvaluationResultExpectationItemProvider(
					this);
		}

		return queryEvaluationResultExpectationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.ErrorResult} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ErrorResultItemProvider errorResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.ErrorResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createErrorResultAdapter() {
		if (errorResultItemProvider == null) {
			errorResultItemProvider = new ErrorResultItemProvider(this);
		}

		return errorResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.SerializableResult}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SerializableResultItemProvider serializableResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.SerializableResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSerializableResultAdapter() {
		if (serializableResultItemProvider == null) {
			serializableResultItemProvider = new SerializableResultItemProvider(
					this);
		}

		return serializableResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.EnumeratorResult}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EnumeratorResultItemProvider enumeratorResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.EnumeratorResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEnumeratorResultAdapter() {
		if (enumeratorResultItemProvider == null) {
			enumeratorResultItemProvider = new EnumeratorResultItemProvider(
					this);
		}

		return enumeratorResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.BooleanResult} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected BooleanResultItemProvider booleanResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.BooleanResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createBooleanResultAdapter() {
		if (booleanResultItemProvider == null) {
			booleanResultItemProvider = new BooleanResultItemProvider(this);
		}

		return booleanResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.StringResult} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected StringResultItemProvider stringResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.StringResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStringResultAdapter() {
		if (stringResultItemProvider == null) {
			stringResultItemProvider = new StringResultItemProvider(this);
		}

		return stringResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.EmptyResult} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EmptyResultItemProvider emptyResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.EmptyResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEmptyResultAdapter() {
		if (emptyResultItemProvider == null) {
			emptyResultItemProvider = new EmptyResultItemProvider(this);
		}

		return emptyResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.IntegerResult} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IntegerResultItemProvider integerResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.IntegerResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createIntegerResultAdapter() {
		if (integerResultItemProvider == null) {
			integerResultItemProvider = new IntegerResultItemProvider(this);
		}

		return integerResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.QueryValidationResultExpectation}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected QueryValidationResultExpectationItemProvider queryValidationResultExpectationItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.QueryValidationResultExpectation}
	 * . <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createQueryValidationResultExpectationAdapter() {
		if (queryValidationResultExpectationItemProvider == null) {
			queryValidationResultExpectationItemProvider = new QueryValidationResultExpectationItemProvider(
					this);
		}

		return queryValidationResultExpectationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.QueryValidationResult}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected QueryValidationResultItemProvider queryValidationResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.QueryValidationResult}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createQueryValidationResultAdapter() {
		if (queryValidationResultItemProvider == null) {
			queryValidationResultItemProvider = new QueryValidationResultItemProvider(
					this);
		}

		return queryValidationResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.ValidationMessage}
	 * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ValidationMessageItemProvider validationMessageItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.ValidationMessage}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createValidationMessageAdapter() {
		if (validationMessageItemProvider == null) {
			validationMessageItemProvider = new ValidationMessageItemProvider(
					this);
		}

		return validationMessageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.InvalidResult} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InvalidResultItemProvider invalidResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.InvalidResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInvalidResultAdapter() {
		if (invalidResultItemProvider == null) {
			invalidResultItemProvider = new InvalidResultItemProvider(this);
		}

		return invalidResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link org.eclipse.acceleo.query.tests.qmodel.EObjectResult} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EObjectResultItemProvider eObjectResultItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link org.eclipse.acceleo.query.tests.qmodel.EObjectResult}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEObjectResultAdapter() {
		if (eObjectResultItemProvider == null) {
			eObjectResultItemProvider = new EObjectResultItemProvider(this);
		}

		return eObjectResultItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory
				.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the
	 * adapter. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>)
					|| (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to
	 * {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void dispose() {
		if (queryItemProvider != null)
			queryItemProvider.dispose();
		if (eObjectVariableItemProvider != null)
			eObjectVariableItemProvider.dispose();
		if (listResultItemProvider != null)
			listResultItemProvider.dispose();
		if (setResultItemProvider != null)
			setResultItemProvider.dispose();
		if (queriesItemProvider != null)
			queriesItemProvider.dispose();
		if (modelElementItemProvider != null)
			modelElementItemProvider.dispose();
		if (queryEvaluationResultExpectationItemProvider != null)
			queryEvaluationResultExpectationItemProvider.dispose();
		if (errorResultItemProvider != null)
			errorResultItemProvider.dispose();
		if (serializableResultItemProvider != null)
			serializableResultItemProvider.dispose();
		if (enumeratorResultItemProvider != null)
			enumeratorResultItemProvider.dispose();
		if (booleanResultItemProvider != null)
			booleanResultItemProvider.dispose();
		if (stringResultItemProvider != null)
			stringResultItemProvider.dispose();
		if (emptyResultItemProvider != null)
			emptyResultItemProvider.dispose();
		if (integerResultItemProvider != null)
			integerResultItemProvider.dispose();
		if (queryValidationResultExpectationItemProvider != null)
			queryValidationResultExpectationItemProvider.dispose();
		if (queryValidationResultItemProvider != null)
			queryValidationResultItemProvider.dispose();
		if (validationMessageItemProvider != null)
			validationMessageItemProvider.dispose();
		if (invalidResultItemProvider != null)
			invalidResultItemProvider.dispose();
		if (eObjectResultItemProvider != null)
			eObjectResultItemProvider.dispose();
	}

}
