[![Build Status](https://travis-ci.org/smartcat-labs/ranger.svg?branch=master)](https://travis-ci.org/smartcat-labs/ranger)
[ ![Download](https://api.bintray.com/packages/smartcat-labs/maven/ranger/images/download.svg) ](https://bintray.com/smartcat-labs/maven/ranger/_latestVersion)

# Ranger

It allows developers to quickly and in a simple manner define and create large number of objects whose attributes have randomly selected values from the configured set.

It can be used for following:

- quickly populate the database with meaningful values
- create data based on defined rules (e.g. create 100 users out of which 10 have first name 'John' and they are born in 1980) in order to create test data for automated unit and integration tests
- have meaningful data for load testing

```java
ObjectGenerator<User> userGenerator = new ObjectGenerator.Builder<User>(User.class)
  .withValues("username", "destroyerOfW0rldz", "only_lol_catz", "aragorn_the_gray")
  .withValues("firstname", "Alice", "Bob", "Charlie", "David")
  .withValues("lastname", "Zed", "Yvette","Xavier")
  .withRanges("numberOfCards", 1L, 5L)
  .withRanges("accountBalance", 2.72, 2.73)
  .withSubList("favoriteMovies", "Predator")
  .withSubSet("nicknames", "al", "billie", "gray")
  .withRanges("birthDate", LocalDateTime.of(1975, 1, 1, 0, 0), LocalDateTime.of(2001, 1, 1, 0, 0))
  .withObjectGenerator("address", addressGenerator)
  .toBeGenerated(1000).build();

AggregatedObjectGenerator<User> aggregatedUserGenerator = new AggregatedObjectGenerator.Builder<>()
  .withObjectGenerator(userGenerator).build();
List<User> users = aggregatedUserGenerator.generateAll();
```

It can be used as a Java library, programatically in unit and integration tests, and from the command line (though the last one is not yet implemented).

# How to use?

Artifact can be fetched from bintray.

Add following `<repository>` element to your `<repositories>` section in `pom.xml`:

```xml
<repository>
  <id>bintray-smartcat-labs-maven</id>
  <name>bintray</name>
  <url>https://dl.bintray.com/smartcat-labs/maven</url>
</repository>
```

Add the `<dependency>` element to your `<dependencies>` section in `pom.xml` with specific `version` you need:

```xml
<dependency>
  <groupId>io.smartcat</groupId>
  <artifactId>ranger</artifactId>
  <version>version</version>
</dependency>
```

Similarly, dependency can be added to any other build tool supporting maven dependencies.

For showcase and usage examples, take a look at our [Ranger Demo](https://github.com/smartcat-labs/ranger-demo) application.

# Why?

Totally random test data is not so useful:

![Random users table](images/table-random-users.png)

- It is hard to make it by certain rules
- It is hard to reason about it
- It does not reflect production data values nor distribution

What we can do is use contextual data generator and create users whose attribute values make sense in the domain context. We can also say, for example, that 70% of created users should be females. The table will then look like this:

![Context users table](images/table-not-so-random.png)

# How it works?

Ranger uses reflection to set the property with value generated by the rule. Rule can be specified in several ways, usually specifying list of allowed values or range and distribution to use.

# Examples

Create 1000 instances of User entity, out of which exactly 100 users have first name John or Joan.

```java
ObjectGenerator<User> randomUserGenerator = new ObjectGenerator.Builder<User>(User.class)
  .withValues("username", "destroyerOfW0rldz", "only_lol_catz", "aragorn_the_gray")
  .withValues("firstname", "Alice", "Bob", "Charlie", "David")
  ...
  .toBeGenerated(900).build();

ObjectGenerator<User> johnUserGenerator = new ObjectGenerator.Builder<User>(User.class)
  .withValues("username", "destroyerOfW0rldz", "only_lol_catz", "aragorn_the_gray")
  .withValues("firstname", "John", "Joan")
  ...
  .toBeGenerated(100).build();

AggregatedObjectGenerator<User> generator = new AggregatedObjectGenerator.Builder<>()
  .withObjectGenerator(randomUserBuilder)
  .withObjectGenerator(johnUserBuilder).build();
List<User> users = generator.generateAll();
```

Create 1000 instances of User entity, out of which exactly 100 users are born between 1980 and 1990.

```java
ObjectGenerator<User> randomUserGenerator = new RandomBuilder.Builder<User>(User.class)
  .withValues("username", "destroyerOfW0rldz", "only_lol_catz", "aragorn_the_gray")
  .withRanges("birthdate", 
    LocalDateTime.of(1975, 1, 1, 0, 0), LocalDateTime.of(1980, 1, 1, 0, 0), 
    LocalDateTime.of(1990, 1, 1, 0, 0), LocalDateTime.of(2001, 1, 1, 0, 0)) // creates values from two ranges [1975, 1980) and [1990,2001)
  ...
  .toBeGenerated(900).build();

ObjectGenerator<User> millenialUserBuilder = new ObjectGenerator.Builder<User>(User.class)
  .withValues("username", "destroyerOfW0rldz", "only_lol_catz", "aragorn_the_gray")
  .withRanges("birthdate", LocalDateTime.of(1980, 1, 1, 0, 0), LocalDateTime.of(1990, 1, 1, 0, 0))
  ...
  .toBeGenerated(100).build();

AggregatedObjectGenerator<User> userGenerator = new AggregatedObjectGenerator.Builder<>()
  .withObjectGenerator(randomUserBuilder)
  .withObjectGenerator(millenialUserBuilder).build();
List<User> users = userGenerator.generateAll();
```

Create 100 instances of User entity with addreses generated by declared builder:

```java
ObjectGenerator<Address> randomAddressGenerator = new ObjectGenerator.Builder<Address>(Address.class)
  .withValues("city", "New York", "San Francisko", "Boston", "Los Angelese", "Las Vegas", "Austin", "Denver", "Seatle")
  .withValues("street", "Anderson Mill Road", "14 Tee Dr", "3 Oaks Cir", "Adobe Trail", "Clayton Ln", "Foy Cir")
  .withRanges("houseNumber", 1L, 150L).build();

ObjectGenerator<User> randomUserGenerator = new ObjectGenerator.Builder<User>(User.class)
  .withValues("username", "destroyerOfW0rldz")
  .withObjectGenerator("address", randomAddressGenerator).toBeGenerated(100).build();

AggregatedObjectGenerator<User> generator = new AggregatedObjectGenerator.Builder<>()
  .withObjectGenerator(randomUserBuilder).build();
List<User> users = generator.generateAll();
```
