import fs from 'node:fs';
import path from 'node:path';
import type { Options } from 'prettier';
import { format } from 'prettier';
import options from '../.prettierrc.cjs';

const rootPath = path.resolve(__dirname, '..');
const mimeDbPath = path.resolve(rootPath, 'node_modules/mime-db/db.json');
const mimeDbLicencePath = path.resolve(
  rootPath,
  'node_modules/mime-db/LICENSE'
);
const mimeTypesTsPath = path.resolve(
  rootPath,
  'src/locales/en/system/mimeTypes.ts'
);
const prettierTsOptions: Options = { ...options, parser: 'typescript' };
fs.readFile(mimeDbPath, 'utf8', (err, data) => {
  if (err) {
    throw err;
  }

  const licence = fs.readFileSync(mimeDbLicencePath, { encoding: 'utf8' });
  const mimeTypeFileContent = `// This file is generated by scripts/copyMimeTypes.ts\n// Do not edit this file directly. Instead, update mime-db and run \`pnpm run copy:mime-types\`\n\n/*\n${
    licence as string
  }*/\n\nexport default ${data as string};\n`;

  fs.writeFile(
    mimeTypesTsPath,
    format(mimeTypeFileContent, prettierTsOptions),
    (err) => {
      if (err) {
        throw err;
      }

      console.log(`Mime types copied to ${mimeTypesTsPath as string}`);
    }
  );
});
