<?php

namespace Solital\Core\Http\Controller;

use Solital\Core\Kernel\Application;
use Solital\Core\Wolf\Wolf;
use Solital\Core\Http\Controller\{
    BaseControllerTrait,
    HttpControllerTrait
};

abstract class Controller extends Wolf
{
    use BaseControllerTrait;
    use HttpControllerTrait;

    /**
     * Remove all get param
     * 
     * @return void
     */
    public function removeParamsUrl(): void
    {
        $reflection = new \ReflectionFunction('remove_param');
        $reflection->invoke();
    }

    /**
     * Generate password hash using PHP Secure Password component
     *
     * @param string $value
     * @param bool $info
     * 
     * @return string
     */
    public function passHash(string $value, bool $info = false): string
    {
        return Application::provider('solital-password')->create($value, $info);
    }

    /**
     * Checks the hash generated by the `pass_hash` helper or the PHP Secure Password component
     *
     * @param string $value
     * @param string $hash
     * 
     * @return bool
     */
    public function passVerify(string $value, string $hash): bool
    {
        return Application::provider('solital-password')->verify($value, $hash);
    }
}
