<?php

use Solital\Core\Kernel\Application;

/**
 * Generate password hash using PHP Secure Password component
 * 
 * @param string $password
 * @param bool $info
 * 
 * @return string
 */
function pass_hash(#[\SensitiveParameter] string $password, bool $info = false): string
{
    return Application::provider('solital-password')->create($password, $info);
}

/**
 * Checks the hash generated by the `pass_hash` helper or the PHP Secure Password component
 * 
 * @param string $password
 * @param string $hash
 * 
 * @return bool
 */
function pass_verify(#[\SensitiveParameter] string $password, string $hash): bool
{
    return Application::provider('solital-password')->verify($password, $hash);
}
