# [Welcome](welcome.md)
# [About .NET](about/index.md)
## [.NET Products](about/products.md)
# [C# Guide](csharp/index.md)
## [🔧 Getting Started](csharp/getting-started/index.md)
### [🔧 Getting started with Visual Studio](csharp/getting-started/with-visual-studio.md)
### [🔧 Getting started with Visual Studio Code and OmniSharp](csharp/getting-started/with-visual-studio-code.md)
### [🔧 Getting started with cross-platform tools](csharp/getting-started/with-cross-platform-tools.md)
### [🔧 Getting started with C# Interactive](csharp/getting-started/with-csharp-interactive.md)
## [Tutorials](csharp/tutorials/index.md)
### [🔧 Using Visual Studio to create, debug, and deploy an application](csharp/tutorials/create-debug-deploy.md)
### [🔧 Using C# Interactive to explore and experiment](csharp/tutorials/exploring-with-csharp-interactive.md)
### [🔧 Creating portable libraries](csharp/tutorials/creating-portable-libraries.md)
### [🔧 Asynchronous UI programming](csharp/tutorials/asynchronous-ui-programming.md)
### [🔧 Asynchronous server programming](csharp/tutorials/asynchronous-server-programming.md)
### [🔧 Concurrent programming](csharp/tutorials/concurrent-programming.md)
### [Console Application](csharp/tutorials/console-teleprompter.md)
### [REST client](csharp/tutorials/console-webapiclient.md)
### [Working with LINQ](csharp/tutorials/working-with-linq.md)
### [Microservices hosted in Docker](csharp/tutorials/microservices.md)
## [Tour of C#](csharp/tour-of-csharp/index.md)
### [Program Structure](csharp/tour-of-csharp/program-structure.md)
### [Types and Variables](csharp/tour-of-csharp/types-and-variables.md)
### [Expressions](csharp/tour-of-csharp/expressions.md)
### [Statements](csharp/tour-of-csharp/statements.md)
### [Classes and objects](csharp/tour-of-csharp/classes-and-objects.md)
### [Structs](csharp/tour-of-csharp/structs.md)
### [Arrays](csharp/tour-of-csharp/arrays.md)
### [Interfaces](csharp/tour-of-csharp/interfaces.md)
### [Enums](csharp/tour-of-csharp/enums.md)
### [Delegates](csharp/tour-of-csharp/delegates.md)
### [Attributes](csharp/tour-of-csharp/attributes.md)
## [🔧 Latest features](csharp/whats-new.md) 
### [🔧 What's new in C# 7](csharp/csharp-7.md)
### [🔧 What's new in C# 6](csharp/csharp-6.md)
## [🔧 C# Interactive](csharp/interactive.md)
### [🔧 Using C# Interactive in Visual Studio](csharp/interactive-with-visualstudio.md)
### [🔧 Using C# Interactive from Powershell](csharp/interactive-with-powershell.md)
### [🔧 Using C# Interactive from MacOS or Linux Terminal](csharp/interactive-with-bash.md)
## [C# Concepts](csharp/concepts.md)
### [🔧 C# Type system](csharp/type-system.md)
### [🔧 Namespaces and Assemblies](csharp/namespaces-and-assemblies.md)
### [🔧 Basic Types](csharp/basic-types.md)
### [🔧 Classes](csharp/classes.md)
### [🔧 Structs](csharp/structs.md)
### [🔧 Interfaces](csharp/interfaces.md)
### [🔧 Methods and Lambda Expressions](csharp/lambda-expressions.md)
### [Properties](csharp/properties.md)
### [Indexers](csharp/indexers.md)
### [🔧 Generics](csharp/generics.md)
### [Iterators](csharp/iterators.md)
### [Delegates & events](csharp/delegates-events.md)
#### [Introduction to Delegates](csharp/delegates-overview.md)
#### [System.Delegate and the delegate keyword](csharp/delegate-class.md)
#### [Strongly Typed Delegates](csharp/delegates-strongly-typed.md)
#### [Common Patterns for Delegates](csharp/delegates-patterns.md)
#### [Introduction to Events](csharp/events-overview.md)
#### [The .NET Event Pattern](csharp/event-pattern.md)
#### [The Updated .NET Event Pattern](csharp/modern-events.md)
#### [Distinguishing Delegates and Events](csharp/distinguish-delegates-events.md)
### [🔧 Language Integrated Query (LINQ)](csharp/linq.md)
### [Asynchronous programming](csharp/async.md)
### [🔧 Parallel programming](csharp/parallel.md)
### [Expression Trees](csharp/expression-trees.md)
#### [Expression Trees Explained](csharp/expression-trees-explained.md)
#### [Framework Types Supporting Expression Trees](csharp/expression-classes.md)
#### [Executing Expressions](csharp/expression-trees-execution.md)
#### [Interpreting Expressions](csharp/expression-trees-interpreting.md)
#### [Building Expressions](csharp/expression-trees-building.md)
#### [Translating Expressions](csharp/expression-trees-translating.md)
#### [Summary](csharp/expression-trees-summary.md)
### [🔧 Native interoperability](csharp/interop.md)
### [🔧 Reflection & code generation](csharp/reflection.md)
### [Documenting your code](csharp/codedoc.md) 
## [🔧 Using the .NET Compiler Platform](csharp/roslyn/index.md)
## [🔧 Syntax Reference](csharp/syntax.md)
<!--
    The C# Reference section can be ported from here: 
    https://msdn.microsoft.com/en-us/library/618ayhy6.aspx

    with appropriate updates for the latest version of the language.

    Or, should this instead point to an online version of the C# Language spec? 
-->

<!-- F# Content -->
# [F# Guide](fsharp/index.md)

## [Tour of F#](fsharp/tour.md)

## [Introduction to Functional Programming](fsharp/introduction-to-functional-programming/index.md)
### [Functions as First-Class Values](fsharp/introduction-to-functional-programming/functions-as-first-class-values.md)

## [Tutorials](fsharp/tutorials/index.md)
### [Getting Started](fsharp/tutorials/getting-started/index.md)
#### [Getting Started with Visual Studio](fsharp/tutorials/getting-started/getting-started-visual-studio.md)
#### [Getting Started with Visual Studio Code and Ionide](fsharp/tutorials/getting-started/getting-started-vscode.md)
#### [Getting Started with Command-line Tools](fsharp/tutorials/getting-started/getting-started-command-line.md)
### [F# Interactive](fsharp/tutorials/fsharp-interactive/index.md)
#### [F# Interactive Options](fsharp/tutorials/fsharp-interactive/fsharp-interactive-options.md)
### [Type Providers](fsharp/tutorials/type-providers/index.md)
#### [Accessing a SQL Database by Using Type Providers](fsharp/tutorials/type-providers/accessing-a-sql-database.md)
#### [Accessing a SQL Database by Using Type Providers and Entities](fsharp/tutorials/type-providers/accessing-a-sql-database-entities.md)
#### [Accessing an OData Service by Using Type Providers](fsharp/tutorials/type-providers/accessing-an-odata-service.md)
#### [Accessing a Web Service Using Type Providers](fsharp/tutorials/type-providers/accessing-a-web-service.md)
#### [Generating F# Types from a DBML File](fsharp/tutorials/type-providers/generating-fsharp-types-from-dbml.md)
#### [Generating F# Types from an EDMX File](fsharp/tutorials/type-providers/generating-fsharp-types-from-edmx.md)
#### [Creating a Type Provider](fsharp/tutorials/type-providers/creating-a-type-provider.md)
#### [Type provider Security](fsharp/tutorials/type-providers/type-provider-security.md)
#### [Troubleshooting Type Providers](fsharp/tutorials/type-providers/troubleshooting-type-providers.md)
### [Asynchronous and Concurrent Programming](fsharp/tutorials/asynchronous-and-concurrent-programming/index.md)
#### [Asynchronous Programming](fsharp/tutorials/asynchronous-and-concurrent-programming/async.md)

## [Using F# in Visual Studio](fsharp/using-fsharp-in-visual-studio/index.md)
### [Visual F# Development Environment Features](fsharp/using-fsharp-in-visual-studio/visual-fsharp-development-environment-features.md)
### [Configuring Projects](fsharp/using-fsharp-in-visual-studio/configuring-projects.md)
### [Targeting Older Versions of .NET](fsharp/using-fsharp-in-visual-studio/targeting-older-versions-of-net.md)

## [Using F# on Azure](fsharp/using-fsharp-on-azure/index.md)
### [Using F# on Azure Service Fabric](fsharp/using-fsharp-on-azure/using-fsharp-on-azure-service-fabric.md)

## [F# Language Reference](fsharp/language-reference/index.md)
### [Keyword Reference](fsharp/language-reference/keyword-reference.md)
### [Symbol and Operator Reference](fsharp/language-reference/symbol-and-operator-reference/index.md)
#### [Arithmetic Operators](fsharp/language-reference/symbol-and-operator-reference/arithmetic-operators.md)
#### [Boolean Operators](fsharp/language-reference/symbol-and-operator-reference/boolean-operators.md)
#### [Bitwise Operators](fsharp/language-reference/symbol-and-operator-reference/bitwise-operators.md)
#### [Nullable Operators](fsharp/language-reference/symbol-and-operator-reference/nullable-operators.md)
### [Functions](fsharp/language-reference/functions/index.md)
#### [let Bindings](fsharp/language-reference/functions/let-bindings.md)
#### [do Bindings](fsharp/language-reference/functions/do-bindings.md)
#### [Lambda Expressions: the fun keyword](fsharp/language-reference/functions/lambda-expressions-the-fun-keyword.md)
#### [Recursive Functions: the rec keyword](fsharp/language-reference/functions/recursive-functions-the-rec-keyword.md)
#### [Entry Point](fsharp/language-reference/functions/entry-point.md)
#### [External Functions](fsharp/language-reference/functions/external-functions.md)
#### [Inline Functions](fsharp/language-reference/functions/inline-functions.md)
### [Values](fsharp/language-reference/values/index.md)
#### [Null Values](fsharp/language-reference/values/null-values.md)
### [Literals](fsharp/language-reference/literals.md)
### [F# Types](fsharp/language-reference/fsharp-types.md)
### [Type Inference](fsharp/language-reference/type-inference.md)
### [Primitive Types](fsharp/language-reference/primitive-types.md)
### [Unit Type](fsharp/language-reference/unit-type.md)
### [Strings](fsharp/language-reference/strings.md)
### [Tuples](fsharp/language-reference/tuples.md)
### [F# Collection Types](fsharp/language-reference/fsharp-collection-types.md)
### [Lists](fsharp/language-reference/lists.md)
### [Options](fsharp/language-reference/options.md)
### [Sequences](fsharp/language-reference/sequences.md)
### [Arrays](fsharp/language-reference/arrays.md)
### [Generics](fsharp/language-reference/generics/index.md)
#### [Automatic Generalization](fsharp/language-reference/generics/automatic-generalization.md)
#### [Constraints](fsharp/language-reference/generics/constraints.md)
#### [Statically Resolved Type Parameters](fsharp/language-reference/generics/statically-resolved-type-parameters.md)
### [Records](fsharp/language-reference/records.md)
### [Discriminated Unions](fsharp/language-reference/discriminated-unions.md)
### [Enumerations](fsharp/language-reference/enumerations.md)
### [Reference Cells](fsharp/language-reference/reference-cells.md)
### [Type Abbreviations](fsharp/language-reference/type-abbreviations.md)
### [Classes](fsharp/language-reference/classes.md)
### [Structures](fsharp/language-reference/structures.md)
### [Inheritance](fsharp/language-reference/inheritance.md)
### [Interfaces](fsharp/language-reference/interfaces.md)
### [Abstract Classes](fsharp/language-reference/abstract-classes.md)
### [Members](fsharp/language-reference/members/index.md)
#### [let Bindings in Classes](fsharp/language-reference/members/let-bindings-in-classes.md)
#### [do Bindings in Classes](fsharp/language-reference/members/do-bindings-in-classes.md)
#### [Properties](fsharp/language-reference/members/properties.md)
#### [Indexed Properties](fsharp/language-reference/members/indexed-properties.md)
#### [Methods](fsharp/language-reference/members/methods.md)
#### [Constructors](fsharp/language-reference/members/constructors.md)
#### [Events](fsharp/language-reference/members/events.md)
#### [Explicit Fields: The `val` Keyword](fsharp/language-reference/members/explicit-fields-the-val-keyword.md)
### [Type Extensions](fsharp/language-reference/type-extensions.md)
### [Parameters and Arguments](fsharp/language-reference/parameters-and-arguments.md)
### [Operator Overloading](fsharp/language-reference/operator-overloading.md)
### [Flexible Types](fsharp/language-reference/flexible-types.md)
### [Delegates](fsharp/language-reference/delegates.md)
### [Object Expressions](fsharp/language-reference/object-expressions.md)
### [Copy and Update Record Expressions](fsharp/language-reference/copy-and-update-record-expressions.md)
### [Casting and Conversions](fsharp/language-reference/casting-and-conversions.md)
### [Access Control](fsharp/language-reference/access-control.md)
### [Conditional Expressions: if...then...else](fsharp/language-reference/conditional-expressions-if-then-else.md)
### [Match Expressions](fsharp/language-reference/match-expressions.md)
### [Pattern Matching](fsharp/language-reference/pattern-matching.md)
### [Active Patterns](fsharp/language-reference/active-patterns.md)
### [Loops: for...to Expression](fsharp/language-reference/loops-for-to-expression.md)
### [Loops: for...in Expression](fsharp/language-reference/loops-for-in-expression.md)
### [Loops: while...do Expression](fsharp/language-reference/loops-while-do-expression.md)
### [Assertions](fsharp/language-reference/assertions.md)
### [Exception Handling](fsharp/language-reference/exception-handling/index.md)
#### [Exception Types](fsharp/language-reference/exception-handling/exception-types.md)
#### [The try...with Expression](fsharp/language-reference/exception-handling/the-try-with-expression.md)
#### [The try...finally Expression](fsharp/language-reference/exception-handling/the-try-finally-expression.md)
#### [The raise Function](fsharp/language-reference/exception-handling/the-raise-function.md)
#### [The failwith Function](fsharp/language-reference/exception-handling/the-failwith-function.md)
#### [The invalidArg Function](fsharp/language-reference/exception-handling/the-invalidArg-function.md)
### [Attributes](fsharp/language-reference/attributes.md)
### [Resource Management: the use Keyword](fsharp/language-reference/resource-management-the-use-keyword.md)
### [Namespaces](fsharp/language-reference/namespaces.md)
### [Modules](fsharp/language-reference/modules.md)
### [Import Declarations: The open Keyword](fsharp/language-reference/import-declarations-the-open-keyword.md)
### [Signatures](fsharp/language-reference/signatures.md)
### [Units of Measure](fsharp/language-reference/units-of-measure.md)
### [XML Documentation](fsharp/language-reference/xml-documentation.md)
### [Lazy Computations](fsharp/language-reference/lazy-computations.md)
### [Computation Expressions](fsharp/language-reference/computation-expressions.md)
### [Asynchronous Workflows](fsharp/language-reference/asynchronous-workflows.md)
### [Query Expressions](fsharp/language-reference/query-expressions.md)
### [Code Quotations](fsharp/language-reference/code-quotations.md)
### [Compiler Directives](fsharp/language-reference/compiler-directives.md)
### [Compiler Options](fsharp/language-reference/compiler-options.md)
### [Source Line, File, and Path Identifiers](fsharp/language-reference/source-line-file-path-identifiers.md)
### [Verbose Syntax](fsharp/language-reference/verbose-syntax.md)
### [Code Formatting Guidelines](fsharp/language-reference/code-formatting-guidelines.md)
<!-- End F# Content -->

# [.NET Standard](standard/index.md)
## [.NET Standard Library](standard/library.md)
## [Frameworks](standard/frameworks.md)
## [What is "managed code"?](standard/managed-code.md)
## [Common Language Runtime (CLR)](standard/clr.md)
## [Language Independence](standard/language-independence.md)
## [Framework Libraries](standard/framework-libraries.md)
## [.NET Class libraries](standard/class-libraries.md)
## [Portability Analyzer](standard/portability-analyzer.md)
## [Handling and throwing exceptions](standard/exceptions.md)
## [.NET Assembly File Format](standard/assembly-format.md)
## [Garbage collection](standard/garbagecollection/index.md)
### [Automatic memory management and garbage collection](standard/garbagecollection/gc.md)
### [Fundamentals of garbage collection](standard/garbagecollection/fundamentals.md)
### [Induced collections](standard/garbagecollection/induced.md)
### [Latency modes](standard/garbagecollection/latency.md)
### [Weak references](standard/garbagecollection/weak-references.md)
### [Cleaning up unmanaged resources](standard/garbagecollection/unmanaged.md)
### [Implementing a dispose method](standard/garbagecollection/implementing-dispose.md)
### [Using objects that implement IDisposable](standard/garbagecollection/using-objects.md)
## [Generic types](standard/generics.md)
## [Delegates and lambdas](standard/delegates-lambdas.md)
## [LINQ](standard/using-linq.md)
## [Common Type System & Common Language Specification](standard/common-type-system.md)
## [Asynchronous programming](standard/async.md)
### [Asynchronous programming in depth](standard/async-in-depth.md)
## [Native interoperability](standard/native-interop.md)
## [Collections and Data Structures](standard/collections/index.md)
### [Selecting a Collection Class](standard/collections/selecting-a-collection-class.md)
### [Commonly Used Collection Types](standard/collections/commonly-used-collection-types.md)
### [When to Use Generic Collections](standard/collections/when-to-use-generic-collections.md)
### [Comparisons and Sorts Within Collections](standard/collections/comparisons-and-sorts-within-collections.md)
### [Sorted Collection Types](standard/collections/sorted-collection-types.md)
### [Hashtable and Dictionary Collection Types](standard/collections/hashtable-and-dictionary-collection-types.md)
### [Thread-Safe Collections](standard/collections/threadsafe/index.md)
#### [BlockingCollection Overview](standard/collections/threadsafe/blockingcollection-overview.md)
#### [When to Use a Thread-Safe Collection](standard/collections/threadsafe/when-to-use-a-thread-safe-collection.md)
#### [How to: Add and Remove Items from a ConcurrentDictionary](standard/collections/threadsafe/how-to-add-and-remove-items.md)
#### [How to: Add and Take Items Individually from a BlockingCollection](standard/collections/threadsafe/how-to-add-and-take-items.md)
#### [How to: Add Bounding and Blocking Functionality to a Collection](standard/collections/threadsafe/how-to-add-bounding-and-blocking.md)
#### [How to: Use ForEach to Remove Items in a BlockingCollection](standard/collections/threadsafe/how-to-use-foreach-to-remove.md)
#### [How to: Use Arrays of Blocking Collections in a Pipeline](standard/collections/threadsafe/how-to-use-arrays-of-blockingcollections.md)
#### [How to: Create an Object Pool by Using a ConcurrentBag](standard/collections/threadsafe/how-to-create-an-object-pool.md)
## [Numerics in .NET Core](standard/numerics.md)
## [Dates, times, and time zones](standard/datetime/index.md)
### [Time zone overview](standard/datetime/time-zone-overview.md)
### [Choosing between DateTime, DateTimeOffset, TimeSpan, and TimeZoneInfo](standard/datetime/choosing-between-datetime.md)
### [Finding the time zones defined on a local system](standard/datetime/finding-the-time-zones-on-local-system.md)
### [How to: enumerate time zones present on a computer](standard/datetime/enumerate-time-zones.md)
### [How to: access the predefined UTC and local time zone objects](standard/datetime/access-utc-and-local.md)
### [How to: instantiate a TimeZoneInfo object](standard/datetime/instantiate-time-zone-info.md)
### [Instantiating a DateTimeOffset object](standard/datetime/instantiating-a-datetimeoffset-object.md)
### [Performing arithmetic operations with dates and times](standard/datetime/performing-arithmetic-operations.md)
### [How to: use time zones in date and time arithmetic](standard/datetime/use-time-zones-in-arithmetic.md)
### [Converting between DateTime and DateTimeOffset](standard/datetime/converting-between-datetime-and-offset.md)
### [Converting times between time zones](standard/datetime/converting-between-time-zones.md)
### [How to: resolve ambiguous times](standard/datetime/resolve-ambiguous-times.md)
### [How to: let users resolve ambiguous times](standard/datetime/let-users-resolve-ambiguous-times.md)

# [.NET Core Guide](core/index.md)
## [Getting started](core/getting-started.md)
## [Windows Prerequisites](core/windows-prerequisites.md)
## [Tutorials](core/tutorials/index.md)
### [Getting started with .NET Core on Windows](core/tutorials/using-on-windows.md)
### [Getting started with .NET Core on macOS](core/tutorials/using-on-macos.md)
### [Getting started with .NET Core on Windows/Linux/macOS using the command line](core/tutorials/using-with-xplat-cli.md)
### [Developing Libraries with Cross Platform Tools](core/tutorials/libraries.md)
### [Developing ASP.NET Core applications](core/tutorials/aspnet-core.md)
### [How to Manage Package Dependency Versions for .NET Core 1.0](core/tutorials/managing-package-dependency-versions.md)
### [Using MSBuild to build .NET Core projects](core/tutorials/target-dotnetcore-with-msbuild.md)
## [Packages, Metapackages and Frameworks](core/packages.md)
## [Deploying](core/deploying/index.md)
### [🔧 Deploying Applications](core/deploying/applications.md)
### [Creating a NuGet Package with Cross Platform Tools](core/deploying/creating-nuget-packages.md)
## [Docker](core/docker/index.md)
### [Building Docker Images for .NET Core Applications](core/docker/building-net-docker-images.md)
## [Unit Testing](core/testing/index.md)
### [Unit Testing with dotnet test](core/testing/unit-testing-with-dotnet-test.md)
### [Unit testing with MSTest on Windows](core/testing/using-mstest-on-windows.md)
## [Releases](core/versions/index.md)
### [Servicing](core/versions/servicing.md)
## [Runtime IDentifier catalog](core/rid-catalog.md)
## [.NET Core Tools](core/tools/index.md)
### [Telemetry](core/tools/telemetry.md)
### [Extensibility Model](core/tools/extensibility.md)
### [Test communication protocol](core/tools/test-protocol.md)
### [Continuous Integration](core/tools/using-ci-with-cli.md)
### [dotnet](core/tools/dotnet.md)
### [dotnet-new](core/tools/dotnet-new.md)
### [dotnet-restore](core/tools/dotnet-restore.md)
### [dotnet-run](core/tools/dotnet-run.md)
### [dotnet-build](core/tools/dotnet-build.md)
### [dotnet-test](core/tools/dotnet-test.md)
### [dotnet-pack](core/tools/dotnet-pack.md)
### [dotnet-publish](core/tools/dotnet-publish.md)
### [dotnet-install-script](core/tools/dotnet-install-script.md)
### [project.json](core/tools/project-json.md)
### [global.json](core/tools/global-json.md)
## [Porting from .NET Framework](core/porting/index.md)
### [Organizing projects for .NET Core](core/porting/project-structure.md)
### [Analyzing third-party dependencies](core/porting/third-party-deps.md)
### [Porting libraries](core/porting/libraries.md)
### [🔧 NuGet packages](core/porting/nuget-packages.md)
## [Migrating from DNX](core/migrating-from-dnx.md)
# [Samples and Tutorials](samples-and-tutorials/index.md)
