# Considerations for OpenLDAP and non-AD directories

The connector comes by default highly optimized for **Active Directory**. To configure it for OpenLDAP or other LDAP directories you will have to customize these settings in the **config.json** file:

```
  "LDAP_USER_BY_NAME": "(cn={0})",
  "LDAP_SEARCH_QUERY": "(&(objectClass=person)(cn={0}))",
  "LDAP_SEARCH_ALL_QUERY": "(objectClass=person)",
```

In some cases, instead of **cn** it might be better to use **uid**.

## Example: OpenDJ

With the OpenDJ Control Panel it's possible to retrieve the list of attributes for each user. This list can help you decide which attribute will be used as the username when authenticating with Auth0.

![](/media/articles/connector/considerations-non-ad/opendj-attributes.png)

In this example John's `cn` is **johndoe** and the `mail` field is set to **johndoe@contoso.com**. If your organization wants users to authenticate using their username (`cn`) you can set the `LDAP_USER_BY_NAME` setting to `(cn={0})`, but if users should authenticate using their email address you should set it to `(mail={0})`.