---
public: false

imagePosition: "right"
budicon: 693
color: "#EB5424"
title: "Easy to implement with Auth0"
---

Using Auth0 you can have MFA implemented in minutes! You can use the out-of-the-box providers or easily integrate **any** different provider using Auth0's extensibility.
To quickly implement MFA perform the following steps:

1. In Auth0's management dashboard, click the **Multifactor Auth** option.

2. Flip the **Enable Multifactor Auth** switch to enable the feature.

3. Select one of the built-in providers (**Google Authenticator**, **Duo**, or others) or plug your own writing a few lines of code in the extensible Auth0 platform.

	![Enabling MFA](https://cdn.auth0.com/content/multi-factor-authentication/enabling-mfa.png)

4.  Customize the provider. Just replace the placeholder with your _CLIENT ID_ and you are good to go!

	![Customizing your MFA Provider](https://cdn.auth0.com/content/multi-factor-authentication/customizing-provider.png)

But the possibilities don't end there, you can even create your own rules on when MFA will be triggered.
