# Copyright (c) 2015, David Hirvonen
# All rights reserved.

# !!! DO NOT PLACE HEADER GUARDS HERE !!!

# Load used modules
include(hunter_add_package)
include(hunter_add_version)
include(hunter_cacheable)
include(hunter_cmake_args)
include(hunter_download)
include(hunter_pick_scheme)

# List of versions here...
hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "4.0.0-p3"
    URL
    "https://github.com/hunter-packages/opencv/archive/v4.0.0-p3.tar.gz"
    SHA1
    f28f59b2fcd96f2b95fb8501be043662b20d3d55
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "4.0.0-p2"
    URL
    "https://github.com/hunter-packages/opencv/archive/v4.0.0-p2.tar.gz"
    SHA1
    936414fd01ead11f6dd9b360cd477ab278eeaac6
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "4.0.0-p0"
    URL
    "https://github.com/hunter-packages/opencv/archive/v4.0.0-p0.tar.gz"
    SHA1
    90680ea3b971c2323e0049c48fa7867a1fd9f3fe
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.4.6-p0"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.4.6-p0.tar.gz"
    SHA1
    70f4da99e5d824c463848d4df8667d5d705af141
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.4.3-p4"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.4.3-p4.tar.gz"
    SHA1
    f1af13fd24cdb433240b1046b5e1391bb19ee748
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.4.3-p2"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.4.3-p2.tar.gz"
    SHA1
    9006574a1a777329fbbdd95c3835f0b3e64c59b6
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.4.3-p1"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.4.3-p1.tar.gz"
    SHA1
    3589a7f19fdaef200091231c4255c5e5bb70b217
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.4.1-p1"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.4.1-p1.tar.gz"
    SHA1
    a3f4f0a29e14eb3ff4ebf834f5505ff63b384332
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.4.1-p0"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.4.1-p0.tar.gz"
    SHA1
    cae0b9c141ca372629f65d09a780e820ea87ae49
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.4.0-p0"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.4.0-p0.tar.gz"
    SHA1
    f4c4e8711cfe6b1aec5178dfeb3cd503fd24c9a8
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.3.1-p1"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.3.1-p1.tar.gz"
    SHA1
    2efff02ce7f3be1454dc2c41d536124a4a6ee048
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.3.1-p0"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.3.1-p0.tar.gz"
    SHA1
    cca79df3db45c1a1d8da3a4952d04d69c1710508
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.3.0-p2"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.3.0-p2.tar.gz"
    SHA1
    27be59f7978a4625401a1041af8d108a47ae745b
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.3.0-p0"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.3.0-p0.tar.gz"
    SHA1
    fc351142139be71b366458fa1572ab004c871774
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.2.0-p2"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.2.0-p2.tar.gz"
    SHA1
    ea8f612eea55dfa6d2f3669d5e9eb4240417444b
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.2.0-p1"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.2.0-p1.tar.gz"
    SHA1
    be088ced81f1b725e1bb76a45806ab044107fba3
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.2.0-p0"
    URL
    "https://github.com/hunter-packages/opencv/releases/download/v3.2.0-p0/v3.2.0-p0.tar.gz"
    SHA1
    901f98202eb12dc2e1cc7f008204a9fb98ea0b13
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.1.0-p3"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.1.0-p3.tar.gz"
    SHA1
    d1f235600e454bcc3ce7d746b6b706e89ed81acc
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.1.0-p2"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.1.0-p2.tar.gz"
    SHA1
    2ad10c43f8be723b604f1cfccce1f7840b7c39ed
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.1.0-p1"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.1.0-p1.tar.gz"
    SHA1
    8b9ef7a227f1840fd7254302199170947f12097f
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.1.0-p0"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.1.0-p0.tar.gz"
    SHA1
    ab503105ce7e5415fc77cf44de0b276008be624f
    )

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p11"
    URL
    "https://github.com/hunter-packages/opencv/releases/download/v3.0.0-p11/v3.0.0-p11.tar.gz"
    SHA1
    3fa05fadc5c2b5e02ada00ccb7752ede660699ab
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p10"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.0.0-p10.tar.gz"
    SHA1
    90bb9721231693b5999619aece8453b0710181d3
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p9"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.0.0-p9.tar.gz"
    SHA1
    b41a71206d0963dcdf934ecf8f0d7ff299c4b57c
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p8"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.0.0-p8.tar.gz"
    SHA1
    8cff7617f0b2a4e59c8a6b0016207476c30ba7e8
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p7"
    URL
    "https://github.com/hunter-packages/opencv/archive/v3.0.0-p7.tar.gz"
    SHA1
    c1e6e32b146a4a19642bcd3ad7e36b4ddcd13ec3
    )

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p6"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.0.0-p6.tar.gz"
    SHA1
    228124cf6076d9da62f1a9a357e350f3e43f81d0
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p5"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.0.0-p5.tar.gz"
    SHA1
    a64a85ad5763bfbe00f73fc53235c6d449dcb641
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p4"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.0.0-p4.tar.gz"
    SHA1
    6e4e5d9f5393da3068bd8b5e732a4fb8df6b997e
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p3"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.0.0-p3.tar.gz"
    SHA1
    950646e668b1985676d9db0af3ae1192fcb12b07
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p2"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.0.0-p2.tar.gz"
    SHA1
    25e36ae663ee9808b13226174572c56f329a6490
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p1"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.0.0-p1.tar.gz"
    SHA1
    096558a176d3f90b0ffe0e3d9440a417e6163f17
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-p0"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.0.0-p0.tar.gz"
    SHA1
    bd1268619c1287b4d7ea1bbf208fa34583ac986a
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-rc1-p0"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.0.0-rc1-p0.tar.gz"
    SHA1
    e04591de27a049851dcd69e42d649e9492c0fd90
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-beta-p2"
    URL
    "https://github.com/hunter-packages/opencv/archive/3.0.0-beta-p2.tar.gz"
    SHA1
    4bac251a2f12df627a8b4b3275025d15238f900c
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "3.0.0-beta"
    URL
    "https://github.com/Itseez/opencv/archive/3.0.0-beta.tar.gz"
    SHA1
    560895197d1a61ed88fab9ec791328c4c57c0179
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "2.4.11-p1"
    URL
    "https://github.com/hunter-packages/opencv/archive/2.4.11-p1.tar.gz"
    SHA1
    44107ad0619b52f1f1a6b084e06915472a7b0de3
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "2.4.11"
    URL
    "https://github.com/Itseez/opencv/archive/2.4.11.tar.gz"
    SHA1
    310a8b0fdb9bf60c6346e9d073ed2409cd1e26b4
)

hunter_add_version(
    PACKAGE_NAME
    OpenCV
    VERSION
    "2.4.10"
    URL
    "https://github.com/Itseez/opencv/archive/2.4.10.tar.gz"
    SHA1
    a0c2d5944364fc4f26b6160b33c03082b1fa08c1
)

if(ANDROID)
  # This feature doesn't work with new CMake 3.7+ toolchains
  set(_android_args ENABLE_PRECOMPILED_HEADERS=OFF)
else()
  set(_android_args "")
endif()

hunter_cmake_args(
    OpenCV
    CMAKE_ARGS
        BUILD_ANDROID_EXAMPLES=OFF
        BUILD_JAVA=OFF
        BUILD_DOCS=OFF
        BUILD_EXAMPLES=OFF
        BUILD_PERF_TESTS=OFF
        BUILD_TESTS=OFF
        BUILD_opencv_apps=OFF
        INSTALL_PYTHON_EXAMPLES=OFF
        BUILD_WITH_STATIC_CRT=OFF # Fix https://github.com/ruslo/hunter/issues/177
        ${_android_args}
        # Find packages in Hunter (instead of building from OpenCV sources)
        BUILD_ZLIB=OFF
        BUILD_TIFF=OFF
        BUILD_PNG=OFF
        BUILD_JPEG=OFF
        BUILD_JASPER=OFF
        BUILD_WEBP=OFF
        # This stuff will build shared libraries. Build with PIC required for dependencies.
        BUILD_opencv_java=OFF
        BUILD_opencv_python2=OFF
        BUILD_opencv_python3=OFF
        # There is not a CUDA package so need to stop OpenCV from searching for it, otherwise
        #  it might pick up the host version
        WITH_CUDA=OFF
        WITH_CUFFT=OFF
        # Fix for https://travis-ci.org/xsacha/hunter/jobs/347083573
        BUILD_opencv_dnn=OFF
        # Fix for https://travis-ci.org/ingenue/hunter/builds/452039597
        WITH_OPENEXR=OFF
        WITH_FFMPEG=OFF
)

# Pick a download scheme
hunter_pick_scheme(DEFAULT url_sha1_cmake)

# Download package.
# Two versions of library will be built:
# Two versions of library will be built:
#     * libexample_A.a
#     * libexample_Ad.a

hunter_cacheable(OpenCV)
hunter_download(
    PACKAGE_NAME OpenCV
    PACKAGE_INTERNAL_DEPS_ID "1"
)
