# Copyright (c) 2013-2014, Ruslan Baratov
# All rights reserved.

# !!! DO NOT PLACE HEADER GUARDS HERE !!!

include(hunter_add_version)
include(hunter_cacheable)
include(hunter_check_toolchain_definition)
include(hunter_cmake_args)
include(hunter_download)
include(hunter_pick_scheme)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.1"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_1.tar.gz"
    SHA1
    ac1f780b1932d9eed79787b388095ebeebddd148
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.1a"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_1a.tar.gz"
    SHA1
    0a7d7382e3e608fc037d4955a0ddad224acc1fc8
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.1b"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_1b.tar.gz"
    SHA1
    1b09930a6099c6c8fa15dd6c6842e134e65e0a31
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.1c"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_1c.tar.gz"
    SHA1
    eb59b090bd757e30b676fb5e80c25ddb5a2f9511
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.0"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_0.tar.gz"
    SHA1
    d7092de956dbb7cb1b48b521a42eb53b01480047
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.0a"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_0a.tar.gz"
    SHA1
    3b93fc64762b6dfafd47c43e074fb15c77f68af4
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.0b"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_0b.tar.gz"
    SHA1
    783666315e96b8f55b28b5e1edcb7ed83e8bc79b
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.0e"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_0e.tar.gz"
    SHA1
    14eaed8edc7e48fe1f01924fa4561c1865c9c8ac
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.0f"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_0f.tar.gz"
    SHA1
    8fd0ba4c9bb98a1d380689704b132fe20c000a19
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.0g"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_0g.tar.gz"
    SHA1
    07a8861dfb51d3ba983668f0f8daeac49bf3dbc3
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.0h"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_0h.tar.gz"
    SHA1
    2168c88516556332ebaf7c31791132025a093c2b
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.0i"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_0i.tar.gz"
    SHA1
    f1748778e06f41e41e9585fd8815339867f22d30
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.0j"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_0j.tar.gz"
    SHA1
    489c7a35a4ee2ab06006b2ee26791445b67293a4
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.1.0k"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_1_0k.tar.gz"
    SHA1
    0a753deaa01df3a231759f3ed01fb0b8e14b5d59
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2s"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2s.tar.gz"
    SHA1
    d3439055ac91862f69089e394f2d29832653de4d
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2r"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2r.tar.gz"
    SHA1
    d4933f2974572edffa395cf9f90e6485652dc3a5
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2q"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2q.tar.gz"
    SHA1
    d9d0876c1d3a06896308b0e0bf67a85c3dd87258
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2p"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2p.tar.gz"
    SHA1
    0c86f89bc272f204919230e7220c070ac486b9e6
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2o"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2o.tar.gz"
    SHA1
    ec7ad3650206f1045d48f2fe9ed4ad93a1228ec5
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2n"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2n.tar.gz"
    SHA1
    6d507bb849c8156f14c2b6f3e269a5e782ff6b82
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2l"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2l.tar.gz"
    SHA1
    5bea0957b371627e8ebbee5bef221519e94d547c
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2k"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2k.tar.gz"
    SHA1
    462944eff7b045d950deaaa86798190cbdc5278a
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2j"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2j.tar.gz"
    SHA1
    ba4d28d1c371285c6bd89fc5903a21b42e09289b
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2i"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2i.tar.gz"
    SHA1
    840a4f94220c6c647bd2193741825c19f5c2f8f6
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2h"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2h.tar.gz"
    SHA1
    ba4eee69aa0e6301cb3dca8a68785ffda018d581
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2g"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2g.tar.gz"
    SHA1
    852817cecfd3407429be833afad6f15a31099deb
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2f"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2f.tar.gz"
    SHA1
    f50af5c7c2f36e7aa4637b678ba137df58e318bc
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2e"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2e.tar.gz"
    SHA1
    889483954383738cf8dcdf2945e151c9374f7631
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2d"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2d.tar.gz"
    SHA1
    a233de65e91dc176f4e34be03899ae00eb1dd029
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2m"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2m.tar.gz"
    SHA1
    f0af7e246a677fd52945e5438eb11ce0de391a4c
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2o"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2o.tar.gz"
    SHA1
    ec7ad3650206f1045d48f2fe9ed4ad93a1228ec5
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.1u"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_1u.tar.gz"
    SHA1
    584482a39a09bdc8737105239ec1c269c8717c08
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.1t"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_1t.tar.gz"
    SHA1
    505870952a3b63253696ed1d9c85473a6a0623eb
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.1s"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_1s.tar.gz"
    SHA1
    e507a45e6a43b900d29cbf573c1f6e7a8c7798e4
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.1e"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_1e.tar.gz"
    SHA1
    4e8e2b21899f0dab567def50680dfd02a7acbb1a
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.1d"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_1d.tar.gz"
    SHA1
    d427eaf3e7e399f7f5562e00eebd6f2412903339
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.0k"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_0k.tar.gz"
    SHA1
    84c6ebb9f57af00c4eb7c34d40c97b5d61273037
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "0.9.8y"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_0_9_8y.tar.gz"
    SHA1
    b485a818490bd2818b7e948b26656c11fea77782
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.1f"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_1f.tar.gz"
    SHA1
    f0141b0e8cab4f18bc5d1771fb3ab02f0ae92302
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.1h"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_1h.tar.gz"
    SHA1
    58425104412760c3ec2e4ba8e363da5beb443fde
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.1i"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_1i.tar.gz"
    SHA1
    e4b0f6f98128716788e974a7b60178900a7cf5ec
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.1j"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_1j.tar.gz"
    SHA1
    38b73471e1fcc1edb7ab3e18cc59286116c1de5c
)

hunter_add_version(
    PACKAGE_NAME
    OpenSSL
    VERSION
    "1.0.2a"
    URL
    "https://github.com/openssl/openssl/archive/OpenSSL_1_0_2a.tar.gz"
    SHA1
    072cf2bc8e19c7c59a42e7e20977fe3037c9c9f3
)

if(MINGW)
  hunter_pick_scheme(DEFAULT url_sha1_openssl)
elseif(WIN32)
  if("${HUNTER_OpenSSL_VERSION}" VERSION_LESS "1.1")
    hunter_pick_scheme(DEFAULT url_sha1_openssl_windows)
  else()
    hunter_pick_scheme(DEFAULT url_sha1_openssl_windows_1_1_plus)
  endif()
elseif(APPLE)
  if(IOS)
    hunter_pick_scheme(DEFAULT url_sha1_openssl_ios)
  else()
    hunter_pick_scheme(DEFAULT url_sha1_openssl_macos)
  endif()
else()
  hunter_pick_scheme(DEFAULT url_sha1_openssl)
endif()

if(MINGW)
  hunter_check_toolchain_definition(NAME "__MINGW64__" DEFINED _hunter_mingw64)
  if(_hunter_mingw64)
    hunter_cmake_args(OpenSSL CMAKE_ARGS HUNTER_OPENSSL_MINGW64=TRUE)
  endif()
endif()

hunter_cacheable(OpenSSL)
hunter_download(PACKAGE_NAME OpenSSL PACKAGE_INTERNAL_DEPS_ID "29")
