# Copyright (c) 2013-2017, Ruslan Baratov
# All rights reserved.

# Do not place header guards here

# Unset:
#   * ${PACKAGE_NAME}_ROOT (CMake variable)
#   * ${PACKAGE_NAME}_ROOT (CMake cache variable)
#   * ${PACKAGE_NAME}_ROOT (environment variable)

# Set CMake variables:
#   * HUNTER_${PACKAGE_NAME}_VERSION
#   * HUNTER_${PACKAGE_NAME}_CMAKE_ARGS (optionally)

# Usage:
#   hunter_default_version(Foo VERSION 1.0.0)
#   hunter_default_version(Boo VERSION 1.2.3z CMAKE_ARGS BOO_WITH_A=ON)

# Wiki:
#   * https://github.com/ruslo/hunter/wiki/dev.modules#hunter_default_version

include(hunter_default_version)
include(hunter_user_error)

# NOTE: no names with spaces!

hunter_default_version(AllTheFlopsThreads VERSION 0.1-p0)
hunter_default_version(Android-Apk VERSION 1.1.13)
hunter_default_version(Android-Build-Tools VERSION 22.0.1)
hunter_default_version(Android-Google-Repository VERSION 47)
hunter_default_version(Android-Modules VERSION 1.0.0)
hunter_default_version(Android-SDK VERSION 0.0.5)
hunter_default_version(Android-SDK-Platform-tools VERSION r25.0.5)
hunter_default_version(Android-SDK-Tools VERSION 25.2.5)
hunter_default_version(Android-Support-Repository VERSION 47)
hunter_default_version(ARM_NEON_2_x86_SSE VERSION 1.0.0-p0)
hunter_default_version(ArrayFire VERSION 3.3.1-p0)
hunter_default_version(Assimp VERSION 3.2-p1)
hunter_default_version(Async++ VERSION 0.0.3-hunter)
hunter_default_version(Avahi VERSION 0.6.31)
hunter_default_version(Beast VERSION 1.0.0-b84-hunter-0)
hunter_default_version(BZip2 VERSION 1.0.6-p3)
if(MSVC OR MINGW)
  # FIXME: https://ci.appveyor.com/project/ingenue/hunter/build/1.0.2229
  hunter_default_version(Boost VERSION 1.64.0)
else()
  hunter_default_version(Boost VERSION 1.65.0)
endif()
hunter_default_version(BoostCompute VERSION 0.5-p0)
hunter_default_version(BoostProcess VERSION 0.5)
hunter_default_version(CapnProto VERSION 0.6.1)
hunter_default_version(CLAPACK VERSION 3.2.1)
hunter_default_version(CURL VERSION 7.49.1-DEV-v8)
hunter_default_version(Clang VERSION 4.0.1-p0)
hunter_default_version(ClangToolsExtra VERSION 4.0.1) # Clang
hunter_default_version(Comet VERSION 4.0.2)
hunter_default_version(CppNetlib VERSION 0.10.1-hunter-3)
hunter_default_version(CppNetlibUri VERSION 1.0.4-hunter)
hunter_default_version(CsvParserCPlusPlus VERSION 1.0.1)
hunter_default_version(Eigen VERSION 3.3.4-p0)
hunter_default_version(enet VERSION 1.3.13-p1)
hunter_default_version(Expat VERSION 2.1.1)
if(MSVC)
  hunter_default_version(getopt VERSION 1.0.0-p0)
endif()
hunter_default_version(GPUImage VERSION 0.1.6-p6)
hunter_default_version(GSL VERSION 2.1.0-p2)
hunter_default_version(Igloo VERSION 1.1.1-hunter)
hunter_default_version(intsizeof VERSION 2.0.1)
hunter_default_version(Jpeg VERSION 9b-p3)
hunter_default_version(JsonSpirit VERSION 0.0.4-hunter)
if(MSVC_VERSION LESS 1600)
    # for VS10 - version without support C++11
  hunter_default_version(jsoncpp VERSION 0.7.0)
else()
  hunter_default_version(jsoncpp VERSION 1.8.0)
endif()
hunter_default_version(LAPACK VERSION 3.7.1)
hunter_default_version(LLVM VERSION 4.0.1-p0) # Clang
hunter_default_version(LLVMCompilerRT VERSION 4.0.1-patched) # Clang
hunter_default_version(Leathers VERSION 0.1.6)
hunter_default_version(Leptonica VERSION 1.74.2-p4)
hunter_default_version(Libcxx VERSION 3.6.2) # Clang
hunter_default_version(Libcxxabi VERSION 3.6.2) # Clang
hunter_default_version(librtmp VERSION 2.4.0-p0)
hunter_default_version(Libssh2 VERSION 1.7.0)
hunter_default_version(Lua VERSION 5.3.2)
hunter_default_version(MySQL-client VERSION 6.1.9-p0)
hunter_default_version(NASM VERSION 2.12.02)
hunter_default_version(OpenBLAS VERSION 0.2.20-p0)
hunter_default_version(OpenCL VERSION 2.1-p3)
hunter_default_version(OpenCL-cpp VERSION 2.0.10-p0)
hunter_default_version(OpenCV VERSION 3.3.0-p2)
hunter_default_version(OpenCV-Extra VERSION 3.3.0)
hunter_default_version(OpenNMTTokenizer VERSION 0.2.0-p1)
if(MSVC)
  # FIXME: https://ci.appveyor.com/project/ingenue/hunter/build/1.0.1470
  hunter_default_version(OpenSSL VERSION 1.0.2l)
else()
  hunter_default_version(OpenSSL VERSION 1.1.0f)
endif()
hunter_default_version(PNG VERSION 1.6.26-p1)
hunter_default_version(PocoCpp VERSION 1.7.8-p0)
hunter_default_version(PostgreSQL VERSION 9.6.3)
hunter_default_version(Protobuf VERSION 3.0.0-p1)

string(COMPARE EQUAL "${CMAKE_SYSTEM_NAME}" "Linux" _is_linux)
if(_is_linux OR MINGW)
  # qt-qml example is broken on Linux
  # qt-core example is broken on MinGW
  hunter_default_version(Qt VERSION 5.5.1-cvpixelbuffer-2-p9)
else()
  hunter_default_version(Qt VERSION 5.9.1-p0)
endif()

hunter_default_version(QtAndroidCMake VERSION 1.0.9)
hunter_default_version(QtCMakeExtra VERSION 1.0.27)
hunter_default_version(QtQmlManager VERSION 1.0.0)
hunter_default_version(RapidJSON VERSION 1.0.2-p2)
hunter_default_version(RapidXML VERSION 1.13)
hunter_default_version(SDL2 VERSION 2.0.4-p4)
hunter_default_version(SDL_image VERSION 2.0.1-p1)
hunter_default_version(SDL_mixer VERSION 2.0.1-p1)
hunter_default_version(SQLite3 VERSION autoconf-3080803) #R-Tree enabled
hunter_default_version(Sober VERSION 0.1.3)
hunter_default_version(stormlib VERSION 9.21-p1)
hunter_default_version(Sugar VERSION 1.2.2)
hunter_default_version(SuiteSparse VERSION 4.5.1-p1)
hunter_default_version(TIFF VERSION 4.0.2-p3)
hunter_default_version(tommath VERSION 1.0-p2)
hunter_default_version(tomcrypt VERSION 1.17-p3)
hunter_default_version(WTL VERSION 9.1.5321)
hunter_default_version(WDC VERSION 1.1.1)
hunter_default_version(Washer VERSION 0.1.2)
hunter_default_version(WinSparkle VERSION 0.4.0)
hunter_default_version(ZLIB VERSION 1.2.8-p3)
hunter_default_version(ZMQPP VERSION 4.1.2)
hunter_default_version(ZeroMQ VERSION 4.1.4-p2)
hunter_default_version(caffe VERSION rc3-p2)
hunter_default_version(Catch VERSION 1.8.2-p0)
hunter_default_version(aes VERSION 0.0.1-p1)
hunter_default_version(aglet VERSION 1.2.0)
hunter_default_version(autobahn-cpp VERSION 0.2.0)
hunter_default_version(boost-pba VERSION 1.0.0-p0)
hunter_default_version(ccv VERSION 0.7-p6)
hunter_default_version(cereal VERSION 1.2.2-p0)
hunter_default_version(ceres-solver VERSION 1.12.0-p2)
hunter_default_version(clBLAS VERSION 2.10.0-p0)
hunter_default_version(convertutf VERSION 1.0.1)
hunter_default_version(crashpad VERSION v0.0.1-p0)
hunter_default_version(crashup VERSION 0.0.2)
hunter_default_version(cvmatio VERSION 1.0.27-p3)
hunter_default_version(cxxopts VERSION 1.0.0-p0)
hunter_default_version(czmq VERSION 4.0.2-p1)
hunter_default_version(damageproto VERSION 1.2.1)
hunter_default_version(dbus VERSION 1.10.0-hunter-4)
hunter_default_version(dest VERSION 0.8.0-p4)
hunter_default_version(dlib VERSION 19.6-p0)
hunter_default_version(doctest VERSION 1.2.0)
hunter_default_version(double-conversion VERSION 3.0.0)
hunter_default_version(dri2proto VERSION 2.8)
hunter_default_version(dri3proto VERSION 1.0)
hunter_default_version(drishti_assets VERSION 1.8)
hunter_default_version(drishti_faces VERSION 1.2)
hunter_default_version(drm VERSION 2.4.67)
hunter_default_version(eigen3-nnls VERSION 1.0.0)
hunter_default_version(eos VERSION 0.12.1)
hunter_default_version(FakeIt VERSION 2.0.3)
hunter_default_version(fixesproto VERSION 5.0)
hunter_default_version(flatbuffers VERSION 1.3.0-p3)
hunter_default_version(flex VERSION 2.6.4)
hunter_default_version(fmt VERSION 4.0.0)
hunter_default_version(freetype VERSION 2.6.2)
hunter_default_version(gauze VERSION 0.1.1)
hunter_default_version(geos VERSION 3.4.2)
hunter_default_version(gflags VERSION 2.2.1)
hunter_default_version(glew VERSION 2.0.0)
hunter_default_version(glfw VERSION 3.3.0-p4)
hunter_default_version(glm VERSION 0.9.8.5)
hunter_default_version(glog VERSION 0.3.5-p1)
hunter_default_version(glproto VERSION 1.4.17)
hunter_default_version(half VERSION 1.1.0-p1)
hunter_default_version(hdf5 VERSION 1.8.15-p1)
hunter_default_version(hunter_box_1 VERSION 1.0.1)
hunter_default_version(ice VERSION 1.0.8)
hunter_default_version(imshow VERSION 1.0.0-p0)
hunter_default_version(inputproto VERSION 2.2)
hunter_default_version(intltool VERSION 0.51.0)
hunter_default_version(ios_sim VERSION 3.1.1)
hunter_default_version(ippicv VERSION 20151201)
hunter_default_version(irrXML VERSION 1.2)
hunter_default_version(kbproto VERSION 1.0.6)
hunter_default_version(libdaemon VERSION 0.14)
hunter_default_version(libjson-rpc-cpp VERSION 0.7.0-p3)
hunter_default_version(libogg VERSION 1.3.2-cmake3)
hunter_default_version(libsodium VERSION 1.0.10)
hunter_default_version(libuv VERSION 1.14.0-p1)
hunter_default_version(libxml2 VERSION 2.9.4)
hunter_default_version(libyuv VERSION 1514-p3)
hunter_default_version(log4cplus VERSION 1.2.0-p0)
hunter_default_version(lzma VERSION 5.2.3-p4)
hunter_default_version(mini_chromium VERSION 0.0.1-p2)
hunter_default_version(minizip VERSION 1.0.1-p1)
hunter_default_version(mpark_variant VERSION 1.0.0)
hunter_default_version(msgpack VERSION 1.4.1-p2)
hunter_default_version(mtplz VERSION 0.1-p3)
hunter_default_version(nanoflann VERSION 1.2.3-p0)
hunter_default_version(nlohmann_json VERSION 2.1.1-p1)
hunter_default_version(odb VERSION 2.4.0)
hunter_default_version(odb-boost VERSION 2.4.0)
hunter_default_version(odb-compiler VERSION 2.4.0)
hunter_default_version(odb-mysql VERSION 2.4.0)
hunter_default_version(odb-pgsql VERSION 2.4.0)
hunter_default_version(odb-sqlite VERSION 2.4.0)
hunter_default_version(ogles_gpgpu VERSION 0.2.1)
hunter_default_version(onmt VERSION 0.4.1-p2)
hunter_default_version(openddlparser VERSION 0.1.0-p2)
hunter_default_version(pciaccess VERSION 0.13.4)
hunter_default_version(poly2tri VERSION 1.0.0)
hunter_default_version(polyclipping VERSION 4.8.8-p0) # for Assimp
hunter_default_version(presentproto VERSION 1.0)
hunter_default_version(pthread-stubs VERSION 0.3)
hunter_default_version(pugixml VERSION 1.8.1)
hunter_default_version(rabbitmq-c VERSION 0.7.0-p1)
hunter_default_version(randrproto VERSION 1.3.2)
hunter_default_version(renderproto VERSION 0.11.1)
hunter_default_version(sm VERSION 1.2.1)
hunter_default_version(Snappy VERSION 1.1.6-p0)
hunter_default_version(sse2neon VERSION 1.0.0-p0)
hunter_default_version(sparsehash VERSION 2.0.2)
if(MSVC_VERSION LESS 1800)
    # for VS12 - version without support C++11
  hunter_default_version(spdlog VERSION 1.0.0-p0)
else()
  hunter_default_version(spdlog VERSION 0.13.0-p1)
endif()
hunter_default_version(szip VERSION 2.1.0-p1)
hunter_default_version(Tesseract VERSION 3.05.01-hunter-3)
hunter_default_version(thread-pool-cpp VERSION 1.1.0)
hunter_default_version(tinydir VERSION 1.2-p0)
hunter_default_version(websocketpp VERSION 0.7.0-p2)
hunter_default_version(wxWidgets VERSION 3.0.2)
hunter_default_version(x11 VERSION 1.5.0)
hunter_default_version(x264 VERSION snapshot-20170420-2245)
hunter_default_version(xau VERSION 1.0.7)
hunter_default_version(xcb VERSION 1.11.1)
hunter_default_version(xcb-proto VERSION 1.11)
hunter_default_version(xcursor VERSION 1.1.13)
hunter_default_version(xdamage VERSION 1.1.4)
hunter_default_version(xext VERSION 1.3.1)
hunter_default_version(xextproto VERSION 7.2.1)
hunter_default_version(xf86vidmodeproto VERSION 2.3.1)
hunter_default_version(xfixes VERSION 5.0.1)
hunter_default_version(xgboost VERSION 0.40-p9)
hunter_default_version(xi VERSION 1.6.1)
hunter_default_version(xinerama VERSION 1.1.2)
hunter_default_version(xineramaproto VERSION 1.1.2)
hunter_default_version(xorg-macros VERSION 1.17)
hunter_default_version(xproto VERSION 7.0.23)
hunter_default_version(xrandr VERSION 1.3.2)
hunter_default_version(xrender VERSION 0.9.7)
hunter_default_version(xshmfence VERSION 1.2)
hunter_default_version(xtrans VERSION 1.2.7)
hunter_default_version(xxf86vm VERSION 1.1.2)
hunter_default_version(yaml-cpp VERSION 0.5.3)

if(MSVC80)
  hunter_default_version(GTest VERSION 1.7.0-hunter-6)
else()
  hunter_default_version(GTest VERSION 1.8.0-hunter-p7)
endif()

if(ANDROID)
  string(COMPARE EQUAL "${CMAKE_SYSTEM_VERSION}" "" _is_empty)
  if(_is_empty)
    hunter_user_error("CMAKE_SYSTEM_VERSION is empty")
  endif()

  string(COMPARE EQUAL "${CMAKE_SYSTEM_VERSION}" "21" _is_api_21)
  string(COMPARE EQUAL "${CMAKE_SYSTEM_VERSION}" "19" _is_api_19)
  string(COMPARE EQUAL "${CMAKE_SYSTEM_VERSION}" "16" _is_api_16)

  if(_is_api_21)
    hunter_default_version(Android-Google-APIs VERSION 21_r01)
    hunter_default_version(Android-Google-APIs-Intel-x86-Atom-System-Image VERSION 21_r10)
    hunter_default_version(Android-Intel-x86-Atom-System-Image VERSION 21)
    hunter_default_version(Android-SDK-Platform VERSION 21_r02)
    hunter_default_version(Sources-for-Android-SDK VERSION 21)
    hunter_default_version(Android-ARM-EABI-v7a-System-Image VERSION 21_r04)
  elseif(_is_api_19)
    hunter_default_version(Android-Google-APIs VERSION 19_r18)
    hunter_default_version(Android-Intel-x86-Atom-System-Image VERSION 19)
    hunter_default_version(Android-SDK-Platform VERSION 19_r04)
    hunter_default_version(Sources-for-Android-SDK VERSION 19)
    hunter_default_version(Android-ARM-EABI-v7a-System-Image VERSION 19_r05)
  elseif(_is_api_16)
    hunter_default_version(Android-Google-APIs VERSION 16_r04)
    hunter_default_version(Android-Intel-x86-Atom-System-Image VERSION 16)
    hunter_default_version(Android-SDK-Platform VERSION 16_r05)
    hunter_default_version(Sources-for-Android-SDK VERSION 16)
  else()
    hunter_user_error(
        "Android API (CMAKE_SYSTEM_VERSION)"
        " Expected: `21`, `19`, `16`"
        " Got: `${CMAKE_SYSTEM_VERSION}`"
    )
  endif()
endif()

hunter_default_version(zookeeper VERSION 3.4.9-p2)
hunter_default_version(tacopie VERSION 2.4.0-h1)
hunter_default_version(cpp_redis VERSION 3.5.0-h1)
