/*
 * Copyright 2018 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.quarkus.example.jpa;

import javax.persistence.Embeddable;

/**
 * This is an enmarked @Embeddable class.
 * Let's see if just being referenced by the main entity is enough to be detected.
 *
 * @author Emmanuel Bernard emmanuel@hibernate.org
 */
//FIXME : this used to be non-annotated explicitly for testing purposes
// added the annotation as it's illegal according to the ORM metadata validation
@Embeddable
public class Address {
    private String street1;
    private String street2;
    private String zipCode;

    public String getStreet1() {
        return street1;
    }

    public void setStreet1(String street1) {
        this.street1 = street1;
    }

    public String getStreet2() {
        return street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }
}
