Open Source Code of Conduct
===========================

At Square, we are committed to contributing to the open source community and simplifying the process
of releasing and managing open source software. We’ve seen incredible support and enthusiasm from
thousands of people who have already contributed to our projects — and we want to ensure our community
continues to be truly open for everyone.

This code of conduct outlines our expectations for participants, as well as steps to reporting
unacceptable behavior. We are committed to providing a welcoming and inspiring community for all and
expect our code of conduct to be honored.

Square’s open source community strives to:

 * **Be open**: We invite anyone to participate in any aspect of our projects. Our community is
   open, and any responsibility can be carried by a contributor who demonstrates the required
   capacity and competence.

 * **Be considerate**: People use our work, and we depend on the work of others. Consider users and
   colleagues before taking action. For example, changes to code, infrastructure, policy, and
   documentation may negatively impact others.

 * **Be respectful**: We expect people to work together to resolve conflict, assume good intentions,
   and act with empathy. Do not turn disagreements into personal attacks.

 * **Be collaborative**: Collaboration reduces redundancy and improves the quality of our work. We
   strive for transparency within our open source community, and we work closely with upstream
   developers and others in the free software community to coordinate our efforts.

 * **Be pragmatic**: Questions are encouraged and should be asked early in the process to avoid
   problems later. Be thoughtful and considerate when seeking out the appropriate forum for your
   questions. Those who are asked should be responsive and helpful.

 * **Step down considerately**: Members of every project come and go. When somebody leaves or
   disengages from the project, they should make it known and take the proper steps to ensure that
   others can pick up where they left off.

This code is not exhaustive or complete. It serves to distill our common understanding of a
collaborative, shared environment, and goals. We expect it to be followed in spirit as much as in
the letter.

Diversity Statement
-------------------

We encourage everyone to participate and are committed to building a community for all. Although we
may not be able to satisfy everyone, we all agree that everyone is equal.

Whenever a participant has made a mistake, we expect them to take responsibility for it. If someone
has been harmed or offended, it is our responsibility to listen carefully and respectfully, and do
our best to right the wrong.

Although this list cannot be exhaustive, we explicitly honor diversity in age, culture, ethnicity,
gender identity or expression, language, national origin, political beliefs, profession, race,
religion, sexual orientation, socioeconomic status, and technical ability. We will not tolerate
discrimination based on any of the protected characteristics above, including participants with
disabilities.

Reporting Issues
----------------

If you experience or witness unacceptable behavior — or have any other concerns — please report it by
emailing [codeofconduct@squareup.com][codeofconduct_at]. For more details, please see our Reporting
Guidelines below.

Thanks
------

Some of the ideas and wording for the statements and guidelines above were based on work by the
[Twitter][twitter_coc], [Ubuntu][ubuntu_coc], [GDC][gdc_coc], and [Django][django_coc] communities.
We are thankful for their work.

Reporting Guide
---------------

If you experience or witness unacceptable behavior — or have any other concerns — please report it by
emailing [codeofconduct@squareup.com][codeofconduct_at]. All reports will be handled with
discretion.

In your report please include:

 * Your contact information.
 * Names (real, nicknames, or pseudonyms) of any individuals involved. If there are additional
   witnesses, please include them as well.
 * Your account of what occurred, and if you believe the incident is ongoing. If there is a publicly
   available record (e.g. a mailing list archive or a public IRC logger), please include a link.
 * Any additional information that may be helpful.

After filing a report, a representative from the Square Code of Conduct committee will contact you
personally. The committee will then review the incident, follow up with any additional questions,
and make a decision as to how to respond.

Anyone asked to stop unacceptable behavior is expected to comply immediately. If an individual
engages in unacceptable behavior, the Square Code of Conduct committee may take any action they deem
appropriate, up to and including a permanent ban from all of Square spaces without warning.


[codeofconduct_at]: mailto:codeofconduct@squareup.com
[twitter_coc]: https://github.com/twitter/code-of-conduct/blob/master/code-of-conduct.md
[ubuntu_coc]: https://ubuntu.com/community/code-of-conduct
[gdc_coc]: https://www.gdconf.com/code-of-conduct
[django_coc]: https://www.djangoproject.com/conduct/reporting/

