/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.ElementScanner9;

public class JavacRoundEnvironment
implements RoundEnvironment {
    private final boolean processingOver;
    private final boolean errorRaised;
    private final ProcessingEnvironment processingEnv;
    private final Set<? extends Element> rootElements;
    private static final String NOT_AN_ANNOTATION_TYPE = "The argument does not represent an annotation type: ";

    JavacRoundEnvironment(boolean bl, boolean bl2, Set<? extends Element> set, ProcessingEnvironment processingEnvironment) {
        this.processingOver = bl;
        this.errorRaised = bl2;
        this.rootElements = set;
        this.processingEnv = processingEnvironment;
    }

    public String toString() {
        return String.format("[errorRaised=%b, rootElements=%s, processingOver=%b]", this.errorRaised, this.rootElements, this.processingOver);
    }

    @Override
    public boolean processingOver() {
        return this.processingOver;
    }

    @Override
    public boolean errorRaised() {
        return this.errorRaised;
    }

    @Override
    public Set<? extends Element> getRootElements() {
        return this.rootElements;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement typeElement) {
        Set set = Collections.emptySet();
        if (typeElement.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + typeElement);
        }
        AnnotationSetScanner annotationSetScanner = new AnnotationSetScanner(set);
        for (Element element : this.rootElements) {
            set = (Set)((ElementScanner6)annotationSetScanner).scan(element, typeElement);
        }
        return set;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> clazz) {
        if (!clazz.isAnnotation()) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + clazz);
        }
        String string = clazz.getCanonicalName();
        if (string == null) {
            return Collections.emptySet();
        }
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(string);
        if (typeElement == null) {
            return Collections.emptySet();
        }
        return this.getElementsAnnotatedWith(typeElement);
    }

    private class AnnotationSetScanner
    extends ElementScanner9<Set<Element>, TypeElement> {
        Set<Element> annotatedElements;

        AnnotationSetScanner(Set<Element> set) {
            super(set);
            this.annotatedElements = new LinkedHashSet<Element>();
        }

        @Override
        public Set<Element> visitType(TypeElement typeElement, TypeElement typeElement2) {
            this.scan(typeElement.getTypeParameters(), typeElement2);
            return (Set)super.visitType(typeElement, typeElement2);
        }

        @Override
        public Set<Element> visitExecutable(ExecutableElement executableElement, TypeElement typeElement) {
            this.scan(executableElement.getTypeParameters(), typeElement);
            return (Set)super.visitExecutable(executableElement, typeElement);
        }

        @Override
        public Set<Element> scan(Element element, TypeElement typeElement) {
            List<? extends AnnotationMirror> list = JavacRoundEnvironment.this.processingEnv.getElementUtils().getAllAnnotationMirrors(element);
            for (AnnotationMirror annotationMirror : list) {
                if (!typeElement.equals(annotationMirror.getAnnotationType().asElement())) continue;
                this.annotatedElements.add(element);
            }
            element.accept(this, typeElement);
            return this.annotatedElements;
        }
    }
}

