/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.android.builder.png.Chunk;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class PngWriter {
    private static final Chunk sIend = new Chunk(new byte[]{73, 69, 78, 68});
    public static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    public static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    public static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    public static final byte[] PLTE = new byte[]{80, 76, 84, 69};
    public static final byte[] TRNS = new byte[]{116, 82, 78, 83};
    @NonNull
    private final File mToFile;
    private Chunk mIhdr;
    private final List<Chunk> mChunks = Lists.newArrayList();

    public PngWriter(@NonNull File toFile) {
        this.mToFile = toFile;
    }

    public PngWriter setIhdr(@NonNull Chunk chunk) {
        this.mIhdr = chunk;
        return this;
    }

    public PngWriter setChunk(@NonNull Chunk chunk) {
        this.mChunks.add(chunk);
        return this;
    }

    public PngWriter setChunks(@NonNull List<Chunk> chunks) {
        this.mChunks.addAll(chunks);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.mToFile);
        try {
            fos.write(SIGNATURE);
            this.mIhdr.write(fos);
            for (Chunk chunk : this.mChunks) {
                chunk.write(fos);
            }
            sIend.write(fos);
        }
        finally {
            fos.close();
        }
    }
}

