/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.fixes.AppliedFix;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.io.IOError;
import java.io.IOException;
import javax.tools.JavaFileObject;

public class JavacErrorDescriptionListener
implements DescriptionListener {
    private final Log log;
    private final EndPosTable endPositions;
    private final JavaFileObject sourceFile;
    private final CharSequence sourceFileContent;
    private final Function<Fix, AppliedFix> fixToAppliedFix = new Function<Fix, AppliedFix>(){

        public AppliedFix apply(Fix fix) {
            return AppliedFix.fromSource(JavacErrorDescriptionListener.this.sourceFileContent, JavacErrorDescriptionListener.this.endPositions).apply(fix);
        }
    };
    private static final String MESSAGE_BUNDLE_KEY = "error.prone";

    public JavacErrorDescriptionListener(Log log, EndPosTable endPositions, JavaFileObject sourceFile) {
        this.log = log;
        this.endPositions = (EndPosTable)Preconditions.checkNotNull((Object)endPositions);
        this.sourceFile = sourceFile;
        try {
            this.sourceFileContent = sourceFile.getCharContent(true);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void onDescribed(Description description) {
        JavaFileObject originalSource = this.log.useSource(this.sourceFile);
        ImmutableList appliedFixes = FluentIterable.from(description.fixes).transform(this.fixToAppliedFix).filter(Predicates.notNull()).toList();
        StringBuilder messageBuilder = new StringBuilder(description.getMessage());
        boolean first = true;
        for (AppliedFix appliedFix : appliedFixes) {
            if (first) {
                messageBuilder.append("\nDid you mean ");
            } else {
                messageBuilder.append(" or ");
            }
            if (appliedFix.isRemoveLine()) {
                messageBuilder.append("to remove this line");
            } else {
                messageBuilder.append("'" + appliedFix.getNewCodeSnippet() + "'");
            }
            first = false;
        }
        if (!first) {
            messageBuilder.append("?");
        }
        String message = messageBuilder.toString();
        switch (description.severity) {
            case ERROR: {
                this.log.error((JCDiagnostic.DiagnosticPosition)((Object)description.node), MESSAGE_BUNDLE_KEY, new Object[]{message});
                break;
            }
            case WARNING: {
                this.log.warning((JCDiagnostic.DiagnosticPosition)((Object)description.node), MESSAGE_BUNDLE_KEY, new Object[]{message});
                break;
            }
            case SUGGESTION: {
                this.log.note((JCDiagnostic.DiagnosticPosition)((Object)description.node), MESSAGE_BUNDLE_KEY, new Object[]{message});
                break;
            }
        }
        if (originalSource != null) {
            this.log.useSource(originalSource);
        }
    }
}

