/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;

@BugPattern(name="DeadException", altNames={"ThrowableInstanceNeverThrown"}, summary="Exception created but not thrown", explanation="The exception is created with new, but is not thrown, and the reference is lost.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class DeadException
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    public static final Matcher<Tree> MATCHER = Matchers.allOf(Matchers.parentNode(Matchers.kindIs(Tree.Kind.EXPRESSION_STATEMENT)), Matchers.isSubtypeOf(Suppliers.EXCEPTION_TYPE), Matchers.not(Matchers.enclosingMethod(JUnitMatchers.wouldRunInJUnit4)), Matchers.anyOf(Matchers.not(Matchers.enclosingMethod(JUnitMatchers.isJunit3TestCase)), Matchers.not(Matchers.enclosingClass(JUnitMatchers.isJUnit3TestClass))));

    @Override
    public Description matchNewClass(NewClassTree newClassTree, VisitorState state) {
        if (!MATCHER.matches(newClassTree, state)) {
            return Description.NO_MATCH;
        }
        StatementTree parent = (StatementTree)state.getPath().getParentPath().getLeaf();
        boolean isLastStatement = Matchers.anyOf(new ChildOfBlockOrCase(ChildMultiMatcher.MatchType.LAST, Matchers.isSame(parent)), Matchers.parentNode(Matchers.parentNode(Matchers.kindIs(Tree.Kind.IF)))).matches(newClassTree, state);
        Fix fix = isLastStatement ? SuggestedFix.prefixWith(newClassTree, "throw ") : SuggestedFix.delete(parent);
        return this.describeMatch(newClassTree, fix);
    }

    private static class ChildOfBlockOrCase<T extends Tree>
    extends ChildMultiMatcher<T, StatementTree> {
        public ChildOfBlockOrCase(ChildMultiMatcher.MatchType matchType, Matcher<StatementTree> nodeMatcher) {
            super(matchType, nodeMatcher);
        }

        @Override
        protected Iterable<? extends StatementTree> getChildNodes(T tree, VisitorState state) {
            Object enclosing = state.findEnclosing(CaseTree.class, BlockTree.class);
            if (enclosing == null) {
                return ImmutableList.of();
            }
            if (enclosing instanceof BlockTree) {
                return ((BlockTree)enclosing).getStatements();
            }
            if (enclosing instanceof CaseTree) {
                return ((CaseTree)enclosing).getStatements();
            }
            throw new IllegalStateException("enclosing tree not a BlockTree or CaseTree");
        }
    }
}

