/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.AbstractChainedMatcher;
import com.google.errorprone.matchers.method.AbstractSimpleMatcher;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Type;

public class ParameterMatcherImpl
extends AbstractChainedMatcher<MatchState, MatchState>
implements MethodMatchers.ParameterMatcher {
    private final ImmutableList<Supplier<Type>> expected;
    private static final Function<String, Supplier<Type>> GET_SUPPLIER = new Function<String, Supplier<Type>>(){

        public Supplier<Type> apply(String input) {
            return Suppliers.typeFromString(input);
        }
    };

    ParameterMatcherImpl(AbstractSimpleMatcher<MatchState> baseMatcher, Iterable<String> parameterTypes) {
        this(baseMatcher, (ImmutableList<Supplier<Type>>)ImmutableList.copyOf((Iterable)Iterables.transform(parameterTypes, GET_SUPPLIER)));
    }

    ParameterMatcherImpl(AbstractSimpleMatcher<MatchState> baseMatcher, ImmutableList<Supplier<Type>> parameterTypes) {
        super(baseMatcher);
        this.expected = parameterTypes;
    }

    @Override
    protected Optional<MatchState> matchResult(ExpressionTree item, MatchState info, VisitorState state) {
        ImmutableList actual = ImmutableList.copyOf(info.paramTypes());
        if (info.sym().isVarArgs() ? actual.size() < this.expected.size() : actual.size() != this.expected.size()) {
            return Optional.absent();
        }
        for (int i = 0; i < actual.size(); ++i) {
            if (state.getTypes().isSameType((Type)actual.get(i), (Type)((Supplier)this.expected.get(i)).get(state))) continue;
            return Optional.absent();
        }
        return Optional.of((Object)info);
    }
}

