/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.hpack;

import io.netty.handler.codec.http2.hpack.HeaderField;
import io.netty.handler.codec.http2.hpack.HpackUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class StaticTable {
    private static final String EMPTY = "";
    private static final List<HeaderField> STATIC_TABLE = Arrays.asList(new HeaderField(":authority", ""), new HeaderField(":method", "GET"), new HeaderField(":method", "POST"), new HeaderField(":path", "/"), new HeaderField(":path", "/index.html"), new HeaderField(":scheme", "http"), new HeaderField(":scheme", "https"), new HeaderField(":status", "200"), new HeaderField(":status", "204"), new HeaderField(":status", "206"), new HeaderField(":status", "304"), new HeaderField(":status", "400"), new HeaderField(":status", "404"), new HeaderField(":status", "500"), new HeaderField("accept-charset", ""), new HeaderField("accept-encoding", "gzip, deflate"), new HeaderField("accept-language", ""), new HeaderField("accept-ranges", ""), new HeaderField("accept", ""), new HeaderField("access-control-allow-origin", ""), new HeaderField("age", ""), new HeaderField("allow", ""), new HeaderField("authorization", ""), new HeaderField("cache-control", ""), new HeaderField("content-disposition", ""), new HeaderField("content-encoding", ""), new HeaderField("content-language", ""), new HeaderField("content-length", ""), new HeaderField("content-location", ""), new HeaderField("content-range", ""), new HeaderField("content-type", ""), new HeaderField("cookie", ""), new HeaderField("date", ""), new HeaderField("etag", ""), new HeaderField("expect", ""), new HeaderField("expires", ""), new HeaderField("from", ""), new HeaderField("host", ""), new HeaderField("if-match", ""), new HeaderField("if-modified-since", ""), new HeaderField("if-none-match", ""), new HeaderField("if-range", ""), new HeaderField("if-unmodified-since", ""), new HeaderField("last-modified", ""), new HeaderField("link", ""), new HeaderField("location", ""), new HeaderField("max-forwards", ""), new HeaderField("proxy-authenticate", ""), new HeaderField("proxy-authorization", ""), new HeaderField("range", ""), new HeaderField("referer", ""), new HeaderField("refresh", ""), new HeaderField("retry-after", ""), new HeaderField("server", ""), new HeaderField("set-cookie", ""), new HeaderField("strict-transport-security", ""), new HeaderField("transfer-encoding", ""), new HeaderField("user-agent", ""), new HeaderField("vary", ""), new HeaderField("via", ""), new HeaderField("www-authenticate", ""));
    private static final Map<String, Integer> STATIC_INDEX_BY_NAME = StaticTable.createMap();
    static final int length = STATIC_TABLE.size();

    static HeaderField getEntry(int index) {
        return STATIC_TABLE.get(index - 1);
    }

    static int getIndex(byte[] name) {
        String nameString = new String(name, 0, name.length, HpackUtil.ISO_8859_1);
        Integer index = STATIC_INDEX_BY_NAME.get(nameString);
        if (index == null) {
            return -1;
        }
        return index;
    }

    static int getIndex(byte[] name, byte[] value) {
        int index = StaticTable.getIndex(name);
        if (index == -1) {
            return -1;
        }
        while (index <= length) {
            HeaderField entry = StaticTable.getEntry(index);
            if (!HpackUtil.equals(name, entry.name)) break;
            if (HpackUtil.equals(value, entry.value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static Map<String, Integer> createMap() {
        int length = STATIC_TABLE.size();
        HashMap<String, Integer> ret = new HashMap<String, Integer>(length);
        for (int index = length; index > 0; --index) {
            HeaderField entry = StaticTable.getEntry(index);
            String name = new String(entry.name, 0, entry.name.length, HpackUtil.ISO_8859_1);
            ret.put(name, index);
        }
        return ret;
    }

    private StaticTable() {
    }
}

