﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using Xunit;

namespace System.Windows.Forms.Tests
{
    public class CheckedListBox_CheckedIndexCollectionTests : IClassFixture<ThreadExceptionFixture>
    {
        [WinFormsFact]
        public void CheckedIndexCollection_Ctor_OwnerIsNull_ThrowsArgumentNullException()
        {
            Assert.Throws<ArgumentNullException>("owner", () => { new CheckedListBox.CheckedIndexCollection(null); });
        }
    }
}
