# Release Notes

## General Availability of Microsoft.Data.SqlClient 1.1.2 released 15 April 2020

This update brings the below changes over the previous release:

### Added
- Allowed passing username with Active Directory Interactive Authentication [#493](https://github.com/dotnet/SqlClient/pull/493) [#516](https://github.com/dotnet/SqlClient/pull/516)

### Fixed
- Fixed the ConnectionString's password persistence in .NET Core. [#489](https://github.com/dotnet/SqlClient/pull/489)
- Addressed MARS TDS header containing errors [#510](https://github.com/dotnet/SqlClient/pull/510)

### Changed
- Updated driver libraries to be CLS Compliant [#522](https://github.com/dotnet/SqlClient/pull/522)


## New Features

New features over the 1.0 release of Microsoft.Data.SqlClient.

- [Always Encrypted with secure enclaves](#always-encrypted-with-secure-enclaves) - Always Encrypted is available starting in Microsoft SQL Server 2016. Secure enclaves are available starting in Microsoft SQL Server 2019.

## Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

- System.Data.Common 4.3.0
- Microsoft.Data.SqlClient.SNI [1.1.0,1.2.0)
- Microsoft.Identity.Client 3.0.8
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.5.0
- Microsoft.IdentityModel.JsonWebTokens 5.5.0

#### .NET Core

- Microsoft.Win32.Registry 4.5.0
- runtime.native.System.Data.SqlClient.sni 4.4.0
- System.Security.Principal.Windows 4.5.0
- System.Text.Encoding.CodePages 4.5.0
- System.Configuration.ConfigurationManager 4.5.0
- Microsoft.Identity.Client 3.0.8
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.5.0
- Microsoft.IdentityModel.JsonWebTokens 5.5.0

#### .NET Standard

- Microsoft.Win32.Registry 4.5.0
- runtime.native.System.Data.SqlClient.sni 4.4.0
- System.Buffers 4.4.0
- System.Diagnostics.DiagnosticSource 4.5.0
- System.Memory 4.5.1
- System.Security.Principal.Windows 4.5.0
- System.Text.Encoding.CodePages 4.5.0
- System.Configuration.ConfigurationManager 4.5.0
- Microsoft.Identity.Client 3.0.8

### Always Encrypted with secure enclaves

In general, existing documentation which uses System.Data.SqlClient on .NET Framework should now work with .NET Core, too.

- [Develop using Always Encrypted with .NET Framework Data Provider](https://docs.microsoft.com/sql/relational-databases/security/encryption/develop-using-always-encrypted-with-net-framework-data-provider)
- [Always Encrypted: Protect sensitive data and store encryption keys in the Windows certificate store](https://docs.microsoft.com/azure/sql-database/sql-database-always-encrypted)

In order to use the enclave feature, connection strings should include the required attestation protocol and attestation URL. Examples:

- `Attestation Protocol=HGS;Enclave Attestation Url=<attestation_url_for_HGS>`