# Release Notes

## Microsoft.Data.SqlClient 2.0.0-preview2.20084.1 released 24 March 2020

This update brings the below changes over the previous release:

### Added
- Added support for capturing EventSource traces in .NET Framework, .NET Core, and .NET Standard applications [#399](https://github.com/dotnet/SqlClient/pull/399) [#461](https://github.com/dotnet/SqlClient/pull/461) [#479](https://github.com/dotnet/SqlClient/pull/479) [#483](https://github.com/dotnet/SqlClient/pull/483) [#484](https://github.com/dotnet/SqlClient/pull/484)
- Added support for Cross-platform TCP Keep Alive applicable to .NET Core 3.1+ applications [#395](https://github.com/dotnet/SqlClient/pull/395)
- Added support for enabling Managed networking implementation on Windows applicable to .NET Core and .NET Standard applications [#477](https://github.com/dotnet/SqlClient/pull/477)
- Added `RowsCopied` property in `SqlBulkCopy` to expose count of copied rows [#409](https://github.com/dotnet/SqlClient/pull/409)
- Added "NeutralResourcesLanguage" attribute for .NET Framework assembly [#433](https://github.com/dotnet/SqlClient/pull/433)
- Added caching for invariant culture check result [#376](https://github.com/dotnet/SqlClient/pull/376)
- Added cached `SqlReferenceCollection.FindLiveReaderContext` objects [#380](https://github.com/dotnet/SqlClient/pull/380)

### Fixed
- Fixed Access Token behavior in connection pool to perform string comparison [#443](https://github.com/dotnet/SqlClient/pull/443)
- Fixed concurrent connection speed issues when connecting with Azure Active Directory Authentication modes in .NET Core [#466](https://github.com/dotnet/SqlClient/pull/466)
- Fixed issues with `Password` persistence in Connection String [#453](https://github.com/dotnet/SqlClient/pull/453)

### Changes
- Updated all driver assemblies to be CLS Compliant [#396](https://github.com/dotnet/SqlClient/pull/396)
- Updated Bulk Copy error messages to also include Column, Row and non-encrypted Data information [#437](https://github.com/dotnet/SqlClient/pull/437)
- Updated error messages for "Always Encrypted - Secure Enclaves" to handle 'Attestation Protocol' and fixed typos [#421](https://github.com/dotnet/SqlClient/pull/421) [#397](https://github.com/dotnet/SqlClient/pull/397)
- Removed sync over async in `SNINpHandle.EnableSsl` [#474](https://github.com/dotnet/SqlClient/pull/474)
- Changed non-generic `ArrayList` to `List<T>` in `SqlBulkCopy` [#457](https://github.com/dotnet/SqlClient/pull/457)
- Multiple performance improvements [#377](https://github.com/dotnet/SqlClient/pull/377) [#378](https://github.com/dotnet/SqlClient/pull/378) [#379](https://github.com/dotnet/SqlClient/pull/379) 

### Breaking Changes
- The driver will now perform Server Certificate validation when TLS encryption is enforced by the target Server, which is the default for Azure connections [#391](https://github.com/dotnet/SqlClient/pull/391)
- `SqlDataReader.GetSchemaTable()` now returns empty `DataTable` instead of returning `null` [#419](https://github.com/dotnet/SqlClient/pull/419)


### Introducing EventSource tracing support
This release introduces support for capturing EventSource trace logs for debugging applications. In order to capture these traces, client applications must listen to events from SqlClient's EventSource implementation:

"Microsoft.Data.SqlClient.EventSource"

Supported Event Keywords are:

| Keyword Name | Value | Description |
| ------------ | ----- | ----------- |
| ExecutionTrace | 1 | Turns on capturing Start/Stop events before and after command execution. |
| Trace | 2 | Turns on capturing basic application flow trace events. |
| Scope | 4 | Turns on capturing enter and exit events |
| NotificationTrace | 8 | Turns on capturing `SqlNotification` trace events |
| NotificationScope | 16 | Turns on capturing `SqlNotification` scope enter and exit events |
| PoolerTrace | 32 | Turns on capturing connection pooling flow trace events. |
| PoolerScope | 64 | Turns on capturing connection pooling scope trace events. |
| AdvancedTrace | 128 | Turns on capturing advanced flow trace events. |
| AdvancedTraceBin  | 256 | Turns on capturing advanced flow trace events with additional information. |
| CorrelationTrace | 512 | Turns on capturing correlation flow trace events. |
| StateDump | 1024 | Turns on capturing full state dump of `SqlConnection` |
| SNITrace | 2048 | Turns on capturing flow trace events from Managed Networking implementation (only applicable in .NET Core) |
| SNIScope | 4096 | Turns on capturing scope events from Managed Networking implementation (only applicable in .NET Core) |
|||

### Enabling Managed networking on Windows
This release introduces a new AppContext switch "Microsoft.Data.SqlClient.UseManagedNetworkingOnWindows" that enables the use of Managed SNI on Windows for testing and debugging purposes. This switch will toggle the driver's behavior to use Managed SNI in .NET Core 2.1+ and .NET Standard 2.0+ projects on Windows.

To set the switch from app startup, specify:

```cs
AppContext.SetSwitch("Microsoft.Data.SqlClient.UseManagedNetworkingOnWindows", true);
```

> [NOTE] **Known differences when compared to Native SNI.dll**: Managed SNI does not support non-domain Windows Authentication.


## Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 1.1.0+
- Microsoft.Identity.Client 3.0.8
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Core 2.1

- runtime.native.System.Data.SqlClient.sni 4.4.0 
- Microsoft.Win32.Registry 4.7.0 
- System.Security.Principal.Windows 4.7.0 
- System.Text.Encoding.CodePages 4.7.0 
- System.Diagnostics.DiagnosticSource 4.7.0 
- System.Configuration.ConfigurationManager 4.7.0 
- System.Runtime.Caching 4.7.0 
- Microsoft.Identity.Client 4.7.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Core 3.1

- runtime.native.System.Data.SqlClient.sni 4.4.0 
- Microsoft.Win32.Registry 4.7.0 
- System.Security.Principal.Windows 4.7.0 
- System.Text.Encoding.CodePages 4.7.0 
- System.Diagnostics.DiagnosticSource 4.7.0 
- System.Configuration.ConfigurationManager 4.7.0 
- System.Runtime.Caching 4.7.0 
- Microsoft.Identity.Client 4.7.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Standard

- runtime.native.System.Data.SqlClient.sni 4.4.0
- Microsoft.Win32.Registry 4.7.0
- System.Buffers 4.5.0
- System.Diagnostics.DiagnosticSource 4.7.0
- System.Memory 4.5.3
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Configuration.ConfigurationManager 4.7.0
- Microsoft.Identity.Client 4.7.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0
