# Release Notes

## Microsoft.Data.SqlClient 2.0.0 released 16 June 2020

This update brings the below changes over the previous preview release:

### Added
- Added internal driver support to provide resiliency to DNS failures [#594](https://github.com/dotnet/SqlClient/pull/594)
- Added support for `Active Directory Integrated`, `Active Directory Interactive` and `Active Directory Service Principal` authentication mode for .NET Core and .NET Standard [#560](https://github.com/dotnet/SqlClient/pull/560)
- Added support for `Active Directory Service Principal` authentication mode for .NET Framework [#560](https://github.com/dotnet/SqlClient/pull/560)
- Added support for optional `ORDER` hints in `SqlBulkCopy` for improved performance [#540](https://github.com/dotnet/SqlClient/pull/540)

### Fixed
- Fixed `SqlSequentialStream` multipacket read stalling issue in .NET Core [#603](https://github.com/dotnet/SqlClient/pull/603)
- Fixed code page issue for Kazakh collation in SQL Server [#584](https://github.com/dotnet/SqlClient/pull/584)
- Fixed stalled application issues when end of stream is reached [#577](https://github.com/dotnet/SqlClient/pull/577)
- Fixed driver behavior to not throw exception for invalid configuration file [#573](https://github.com/dotnet/SqlClient/pull/573)
- Fixed Object null reference issue when failover partner is set [#588](https://github.com/dotnet/SqlClient/pull/588)
- Fixed `applicationintent` connection string property issue [#585](https://github.com/dotnet/SqlClient/pull/585)

### Changes
- Raise warning message when insecure TLS protocols are in use [#591](https://github.com/dotnet/SqlClient/pull/591)

### Breaking Changes
- Modified enclave provider interface `SqlColumnEncryptionEnclaveProvider` to be internal along with related classes `SqlEnclaveAttestationParameters` and `SqlEnclaveSession` [#602](https://github.com/dotnet/SqlClient/pull/602) - _This change is not likely to impact customer applications since secure enclaves is a relatively new feature and they would have had to implement their own enclave provider, which is not a trivial task_.
- Updated `SqlClientMetaDataCollectionNames` exposed constants by removing non-existing constants and adding new to the metadata collection [#580](https://github.com/dotnet/SqlClient/pull/580)

## Summary of changes in 2.0

All changes in Microsoft.Data.SqlClient v2.0 over v1.1:

### New Additions
- Added support to allow large UDT buffer size (_upto_ `Int.MaxValue`) as supported by SQL Server starting TDS 7.3 [#340](https://github.com/dotnet/SqlClient/pull/340)
- Added support for capturing EventSource traces in .NET Framework, .NET Core, and .NET Standard applications [#399](https://github.com/dotnet/SqlClient/pull/399) [#461](https://github.com/dotnet/SqlClient/pull/461) [#479](https://github.com/dotnet/SqlClient/pull/479) [#483](https://github.com/dotnet/SqlClient/pull/483) [#484](https://github.com/dotnet/SqlClient/pull/484) [Read More](#eventSource-tracing-support)
- Added support for Cross-platform TCP Keep Alive applicable to .NET Core 3.1+ applications [#395](https://github.com/dotnet/SqlClient/pull/395)
- Added support for enabling Managed networking implementation on Windows applicable to .NET Core and .NET Standard applications [#477](https://github.com/dotnet/SqlClient/pull/477) [Read More](#enable-managed-networking-on-windows)
- Added `RowsCopied` property in `SqlBulkCopy` to expose count of copied rows [#409](https://github.com/dotnet/SqlClient/pull/409) [Read More](#sqlbulkcopy.rowscopied-property)
- Added "NeutralResourcesLanguage" attribute for .NET Framework assembly [#433](https://github.com/dotnet/SqlClient/pull/433)
- Added caching for invariant culture check result [#376](https://github.com/dotnet/SqlClient/pull/376)
- Added cached `SqlReferenceCollection.FindLiveReaderContext` objects [#380](https://github.com/dotnet/SqlClient/pull/380)
- Allow passing username with Active Directory Interactive Authentication [#492](https://github.com/dotnet/SqlClient/pull/492) [Read More](#username-support-for-active-directory-interactive-mode)
- Allow large UDT buffers for .NET Framework [#456](https://github.com/dotnet/SqlClient/pull/456) 
- Added "Transaction Id" and "Client Version" in Diagnostic Source traces [#515](https://github.com/dotnet/SqlClient/pull/515)
- Added new `SqlConnectionOverrides` APIs to perform `SqlConnection.Open()` with fail fast option [#463](https://github.com/dotnet/SqlClient/pull/463) [Read More](#connection-open-overrides)
- Microsoft.Data.SqlClient (.NET Core and .NET Standard) on Windows is now dependent on **Microsoft.Data.SqlClient.SNI.runtime**, replacing the previous dependency on **runtime.native.System.Data.SqlClient.SNI** [#570](https://github.com/dotnet/SqlClient/pull/570) [Read More](#sni-dependency-changes)
- The new **Microsoft.Data.SqlClient.SNI.runtime** dependency adds support for the *ARM* platform along with the already supported platforms *ARM64*, *x64* and *x86* on Windows [#570](https://github.com/dotnet/SqlClient/pull/570) [Read More](#sni-dependency-changes)
- Improved driver performance by introducing managed packet recycling [#389](https://github.com/dotnet/SqlClient/pull/389)
- Added internal driver support to provide resiliency to DNS failures [#594](https://github.com/dotnet/SqlClient/pull/594)
- Added support for `Active Directory Integrated`, `Active Directory Interactive` and `Active Directory Service Principal` authentication mode for .NET Core and .NET Standard [#560](https://github.com/dotnet/SqlClient/pull/560) - [Read more](#additional-active-directory-authentication-modes)
- Added support for `Active Directory Service Principal` authentication mode for .NET Framework [#560](https://github.com/dotnet/SqlClient/pull/560)
- Added support for optional `ORDER` hints in `SqlBulkCopy` for improved performance [#540](https://github.com/dotnet/SqlClient/pull/540) [Read More](#order-hints-for-sqlbulkcopy)

### Bug Fixes
- Fixed issues with `SqlCommandSet` not working with Byte Array parameters [#360](https://github.com/dotnet/SqlClient/pull/360)
- Fixed Statement command cancellation in Managed SNI [#248](https://github.com/dotnet/SqlClient/pull/248) - Ported [dotnet/corefx#38271](https://github.com/dotnet/corefx/pull/38271)
- Fixed zero connection timeout issue in Managed SNI [#332](https://github.com/dotnet/SqlClient/pull/332)
- Fixed "DataType" metadata information for TinyInt datatype to be `System.Byte` [#338](https://github.com/dotnet/SqlClient/pull/338)
- Fixed driver behavior to use `CancellationTokenResource` only for non-infinite timeout and cleanup after usage [#339](https://github.com/dotnet/SqlClient/pull/339)
- Fixed `ConnectionTime` and `ClientConnectionId` reported by `SqlStatistics` when connection is closed [#341](https://github.com/dotnet/SqlClient/pull/341)
- Fixed deadlock issues by reverting async changes to `SNIPacket` [#349](https://github.com/dotnet/SqlClient/pull/349)
- Fixed Access Token behavior in connection pool to perform string comparison [#443](https://github.com/dotnet/SqlClient/pull/443)
- Fixed concurrent connection speed issues when connecting with Azure Active Directory Authentication modes in .NET Core [#466](https://github.com/dotnet/SqlClient/pull/466)
- Fixed issues with `Password` persistence in Connection String [#453](https://github.com/dotnet/SqlClient/pull/453)
- Addressed MARS TDS Header errors by reverting changes to make `SqlDataReader.ReadAsync()` non-blocking [#547](https://github.com/dotnet/SqlClient/pull/547)
- Fixed driver behavior to not perform enlistment of pooled connection in aborted transaction [#543](https://github.com/dotnet/SqlClient/pull/543)
- Fixed wrong application domain selected when starting `SqlDependencyListener` [#410](https://github.com/dotnet/SqlClient/pull/410)
- Added missing refs for `RowCopied` property in `SqlBulkCopy` [#508](https://github.com/dotnet/SqlClient/pull/508)
- Fixed `SqlBulkCopy` to work with database columns containing metadata about data classification [#568](https://github.com/dotnet/SqlClient/pull/568)
- Fixed unsafe cast in `SqlException` for `SerializationEntry.Value` 
- Fixed null reference exceptions in `SqlDelegatedTransaction` methods [#563](https://github.com/dotnet/SqlClient/pull/563)
- Fixed `SqlSequentialStream` multipacket read stalling issue in .NET Core [#603](https://github.com/dotnet/SqlClient/pull/603)
- Fixed code page issue for Kazakh collation in SQL Server [#584](https://github.com/dotnet/SqlClient/pull/584)
- Fixed stalled application issues when end of stream is reached [#577](https://github.com/dotnet/SqlClient/pull/577)
- Fixed driver behavior to not throw exception for invalid configuration file [#573](https://github.com/dotnet/SqlClient/pull/573)
- Fixed Object null reference issue when failover partner is set [#588](https://github.com/dotnet/SqlClient/pull/588)
- Fixed `applicationintent` connection string property issue [#585](https://github.com/dotnet/SqlClient/pull/585)

### Improvements and Changes
- Improved performance of Managed SNI by removing double fetch of domain name [#366](https://github.com/dotnet/SqlClient/pull/366)
- Improved performance of Async Method Allocations in Managed SNI [#328](https://github.com/dotnet/SqlClient/pull/328)
- Improved performance of Managed SNI by enhancing utilization of resources [#173](https://github.com/dotnet/SqlClient/pull/173) - Ported [dotnet/corefx#35363](https://github.com/dotnet/corefx/pull/35363) and [dotnet/corefx#40732](https://github.com/dotnet/corefx/pull/40732)
- Improved performance of Managed SNI RPC Parameter Usage [#209](https://github.com/dotnet/SqlClient/pull/209) - Ported [dotnet/corefx#34049](https://github.com/dotnet/corefx/pull/34049)
- Changed enclave key map to be lazy initialized [#372](https://github.com/dotnet/SqlClient/pull/372)
- Changed `Recieve()` and `ReceiveAsync()` implementation to receive null packets on failure [#350](https://github.com/dotnet/SqlClient/pull/350)
- Changed `EnclaveProviderBase` caching implementation to support Async Scenarios _(Introduces breaking changes)_ [#346](https://github.com/dotnet/SqlClient/pull/346)
- Updated all driver assemblies to be CLS Compliant [#396](https://github.com/dotnet/SqlClient/pull/396)
- Updated Bulk Copy error messages to also include Column, Row and non-encrypted Data information [#437](https://github.com/dotnet/SqlClient/pull/437)
- Updated error messages for "Always Encrypted - Secure Enclaves" to handle 'Attestation Protocol' and fixed typos [#421](https://github.com/dotnet/SqlClient/pull/421) [#397](https://github.com/dotnet/SqlClient/pull/397)
- Removed sync over async in `SNINpHandle.EnableSsl` [#474](https://github.com/dotnet/SqlClient/pull/474)
- Changed non-generic `ArrayList` to `List<T>` in `SqlBulkCopy` [#457](https://github.com/dotnet/SqlClient/pull/457)
- Multiple performance improvements [#377](https://github.com/dotnet/SqlClient/pull/377) [#378](https://github.com/dotnet/SqlClient/pull/378) [#379](https://github.com/dotnet/SqlClient/pull/379) 
- Improved performance by removing unwanted method calls in Event Source tracing [#506](https://github.com/dotnet/SqlClient/pull/506)
- Removed Diagnostic Source and Configuration Manager dependencies from .NET Standard implementation [#535](https://github.com/dotnet/SqlClient/pull/535)
- Removed redundant calls to `DbConnectionPoolKey.GetType()` [#512](https://github.com/dotnet/SqlClient/pull/512)
- Standardized connection string properties for enhanced user experience [#534](https://github.com/dotnet/SqlClient/pull/534) [Read More](#new-connection-string-property-synonyms)
- Improved performance by reducing eventsource tracing related to allocations from TVP write methods [#557](https://github.com/dotnet/SqlClient/pull/557) [#564](https://github.com/dotnet/SqlClient/pull/564)

### Breaking Changes
- The driver will now perform Server Certificate validation when TLS encryption is enforced by the target Server, which is the default for Azure connections [#391](https://github.com/dotnet/SqlClient/pull/391)
- `SqlDataReader.GetSchemaTable()` now returns empty `DataTable` instead of returning `null` [#419](https://github.com/dotnet/SqlClient/pull/419)
- Updated driver to perform decimal scale rounding to match SQL Server behavior [#470](https://github.com/dotnet/SqlClient/pull/470) [Read More](#enable-decimal-truncation-behavior-conditionally)
- For .NET Framework applications consuming **Microsoft.Data.SqlClient**, the `SNI.dll` files previously downloaded to the `bin\x64` and `bin\x86` folders are now named `Microsoft.Data.SqlClient.SNI.x64.dll` and `Microsoft.Data.SqlClient.SNI.x86.dll` and will be downloaded to the `bin` directory, to support auto-loading in the application process [#570](https://github.com/dotnet/SqlClient/pull/570). _This change is not going to impact client applications unless a direct reference has been made to `SNI.dll` or the x86 and x64 folders._
- Modified enclave provider interface `SqlColumnEncryptionEnclaveProvider` to be internal along with related classes `SqlEnclaveAttestationParameters` and `SqlEnclaveSession` [#602](https://github.com/dotnet/SqlClient/pull/602) - _This change is not likely to impact customer applications since secure enclaves is a relatively new feature and they would have had to implement their own enclave provider, which is not a trivial task_.
- Updated `SqlClientMetaDataCollectionNames` exposed constants by removing non-existing constants and adding new to the metadata collection [#580](https://github.com/dotnet/SqlClient/pull/580)
- New connection string property synonyms will replace old properties when fetching connection string from `SqlConnectionStringBuilder` for consistency. [Read More](#new-connection-string-property-synonyms)


### Additional Active Directory authentication modes
This release brings parity of Active Directory authentication modes supported for .NET Framework and .NET Core applications. With the 2.0 stable release, the following authentication modes are supported for **Microsoft.Data.SqlClient**:

|Authentication mechanism | .NET Framework 4.6+ | .NET Core 2.1+ | .NET Standard 2.0+|
|------|--------|--------|--------|
|Active Directory Password | Yes | Yes | Yes |
|Active Directory Integrated | Yes | **Yes**<sup>1</sup>  | **Yes**<sup>1</sup>  |
|Active Directory Interactive | Yes | **Yes**<sup>1</sup>  | **Yes**<sup>1</sup>  |
|**Active Directory Service Principal**<sup>1</sup> | **Yes**<sup>1</sup>  | **Yes**<sup>1</sup>  | **Yes**<sup>1</sup>  |

_<sup>1</sup> New authentication mode starting with Microsoft.Data.SqlClient v2.0_

#### Active Directory Service Principal
This authentication mode uses Active Directory Service Principal to connect to an Azure SQL Database using the client ID and secret of a service principal identity. Service principal authentication involves setting up an App registration with a secret, granting permissions to the App in the Azure SQL Database instance, then connecting with a connection string like the following: 

`Server=tcp:<servername>.database.windows.net;Database=<dbname>;Authentication=Active Directory Service Principal;User Id=<AppId>;Password=<Secret>;`

### EventSource tracing support
This release introduces support for capturing EventSource trace logs for debugging applications. In order to capture these traces, client applications must listen to events from SqlClient's EventSource implementation:

"Microsoft.Data.SqlClient.EventSource"

Supported Event Keywords are:

| Keyword Name | Value | Description |
| ------------ | ----- | ----------- |
| ExecutionTrace | 1 | Turns on capturing Start/Stop events before and after command execution. |
| Trace | 2 | Turns on capturing basic application flow trace events. |
| Scope | 4 | Turns on capturing enter and exit events |
| NotificationTrace | 8 | Turns on capturing `SqlNotification` trace events |
| NotificationScope | 16 | Turns on capturing `SqlNotification` scope enter and exit events |
| PoolerTrace | 32 | Turns on capturing connection pooling flow trace events. |
| PoolerScope | 64 | Turns on capturing connection pooling scope trace events. |
| AdvancedTrace | 128 | Turns on capturing advanced flow trace events. |
| AdvancedTraceBin  | 256 | Turns on capturing advanced flow trace events with additional information. |
| CorrelationTrace | 512 | Turns on capturing correlation flow trace events. |
| StateDump | 1024 | Turns on capturing full state dump of `SqlConnection` |
| SNITrace | 2048 | Turns on capturing flow trace events from Managed Networking implementation (only applicable in .NET Core) |
| SNIScope | 4096 | Turns on capturing scope events from Managed Networking implementation (only applicable in .NET Core) |
|||


### Enable managed networking on Windows
This release introduces a new AppContext switch, "Switch.Microsoft.Data.SqlClient.UseManagedNetworkingOnWindows", that enables the use of Managed SNI on Windows for testing and debugging purposes. This switch will toggle the driver's behavior to use Managed SNI in .NET Core 2.1+ and .NET Standard 2.0+ projects on Windows. Using the managed SNI implementation eliminates the dependency on the native Microsoft.Data.SqlClient.SNI binaries for a fully managed stack.

To set the switch from app startup, specify:

```cs
AppContext.SetSwitch("Switch.Microsoft.Data.SqlClient.UseManagedNetworkingOnWindows", true);
```
> [NOTE] **Known differences when compared to Native SNI.dll**: Managed SNI does not support non-domain Windows Authentication.


### Enable decimal truncation behavior conditionally
Starting with v2.0.0-preview3, the decimal data scale will be rounded by the driver by default as is done by SQL Server.
For backwards compatibility, you can set the [AppContext](https://docs.microsoft.com/en-us/dotnet/api/system.appcontext?view=netframework-4.8) switch "Switch.Microsoft.Data.SqlClient.TruncateScaledDecimal" to "true".

To set the switch at application startup, specify:

```cs
AppContext.SetSwitch("Switch.Microsoft.Data.SqlClient.TruncateScaledDecimal", true);
```

### New Connection string property synonyms

The below connection properties can be interchangeably used with the new synonyms to avoid spacing confusion and for an enhanced user experience.

|Existing connection string property|New Synonym|
|-----------------------------------|-----------|
| ApplicationIntent | Application Intent |
| ConnectRetryCount | Connect Retry Count |
| ConnectRetryInterval | Connect Retry Interval |
| PoolBlockingPeriod | Pool Blocking Period |
| MultipleActiveResultSets | Multiple Active Result Sets |
| MultiSubnetFailover | Multi Subnet Failover |
| TransparentNetworkIPResolution | Transparent Network IP Resolution |
| TrustServerCertificate | Trust Server Certificate |

> Old properties will continue to be supported for backwards compatibility, but the new connection string properties will now be included when fetching connection string from [SqlConnectionStringBuilder](https://docs.microsoft.com/dotnet/api/microsoft.data.sqlclient.sqlconnectionstringbuilder).


#### SqlBulkCopy.RowsCopied property

This property provides read-only access to the number of rows processed in the ongoing bulk copy operation. Note that this value is not necessarily equal to the number of rows added to the destination table. 


#### Connection Open Overrides

The default behavior of `SqlConnection.Open()` can be overridden to disable the ten second delay and automatic connection retries triggered by transient errors.

```csharp
using SqlConnection sqlConnection = new SqlConnection("Data Source=(local);Integrated Security=true;Initial Catalog=AdventureWorks;");
sqlConnection.Open(SqlConnectionOverrides.OpenWithoutRetry);
```

#### Username support for Active Directory Interactive mode

A username can now be specified in the connection string when using Azure Active Directory Interactive authentication mode for both .NET Framework and .NET Core targeted applications.

Set a username using the **User ID** or **UID** connection string property:

```
"Server=<server name>; Database=<dbname>; Authentication=Active Directory Interactive; User Id=<username>;"
```

#### Order hints for SqlBulkCopy

Bulk copy operations offer significant performance advantages over other methods for loading data into a SQL Server table. Performance can be further enhanced by using order hints. Specifying order hints for your bulk copy operations can lower the insertion time of sorted data into tables with clustered indexes.

By default, the bulk insert operation assumes the incoming data is unordered. SQL Server forces an intermediate sort of this data before bulk loading it. If you know that your incoming data is already sorted, you can use order hints to tell the bulk copy operation about the sort order of any destination columns that are part of a clustered index.


#### SNI dependency changes

Microsoft.Data.SqlClient (.NET Core and .NET Standard) on Windows is now dependent on **Microsoft.Data.SqlClient.SNI.runtime**, replacing the previous dependency on **runtime.native.System.Data.SqlClient.SNI**. The new dependency adds support for the `ARM` platform along with the already supported platforms `ARM64`, `x64` and `x86` on Windows.


## Target Platform Support

- .NET Framework 4.6+ (Windows x86, Windows x64)
- .NET Core 2.1+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 2.0.0
- Microsoft.Identity.Client 4.14.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Core 2.1

- Microsoft.Data.SqlClient.SNI.runtime 2.0.0
- Microsoft.Win32.Registry 4.7.0 
- System.Security.Principal.Windows 4.7.0 
- System.Text.Encoding.CodePages 4.7.0 
- System.Diagnostics.DiagnosticSource 4.7.0 
- System.Configuration.ConfigurationManager 4.7.0 
- System.Runtime.Caching 4.7.0 
- Microsoft.Identity.Client 4.14.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Core 3.1

- Microsoft.Data.SqlClient.SNI.runtime 2.0.0
- Microsoft.Win32.Registry 4.7.0 
- System.Security.Principal.Windows 4.7.0 
- System.Text.Encoding.CodePages 4.7.0 
- System.Diagnostics.DiagnosticSource 4.7.0 
- System.Configuration.ConfigurationManager 4.7.0 
- System.Runtime.Caching 4.7.0 
- Microsoft.Identity.Client 4.14.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI.runtime 2.0.0
- Microsoft.Win32.Registry 4.7.0
- System.Buffers 4.5.1
- System.Memory 4.5.4
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- Microsoft.Identity.Client 4.14.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 5.6.0
- Microsoft.IdentityModel.JsonWebTokens 5.6.0
