# Release Notes

## Microsoft.Data.SqlClient 2.1.2 released 3 March 2021

This update brings the below changes over the previous stable release:

### Fixed
- Fixed issue connecting with instance name from a Linux/macOS environment [#874](https://github.com/dotnet/SqlClient/pull/874)
- Fixed wrong results issues by changing the timeout timer to ensure a correct execution state [#929](https://github.com/dotnet/SqlClient/pull/929)
- Fixed a vulnerability by prohibiting `DtdProcessing` on `XmlTextReader` instances in .NET Core [#885](https://github.com/dotnet/SqlClient/pull/885)
- Fixed Kerberos authentication when an SPN does not contain the port [#935](https://github.com/dotnet/SqlClient/pull/935)
- Fixed missing error messages in Managed SNI [#883](https://github.com/dotnet/SqlClient/pull/883)
- Fixed missing `System.Runtime.Caching` dependency for .NET Standard assemblies [#878](https://github.com/dotnet/SqlClient/pull/878)
- Fixed event source tracing issues [#941](https://github.com/dotnet/SqlClient/pull/941)
- Fixed MARS header contains errors issue against .NET Framework 4.8.1 [#928](https://github.com/dotnet/SqlClient/pull/928)



### Target Platform Support

- .NET Framework 4.6+ (Windows x86, Windows x64)
- .NET Core 2.1+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 2.1.1
- Microsoft.Identity.Client 4.21.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Core 2.1

- Microsoft.Data.SqlClient.SNI.runtime 2.1.1
- Microsoft.Win32.Registry 4.7.0
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Diagnostics.DiagnosticSource 4.7.0
- System.Configuration.ConfigurationManager 4.7.0
- System.Runtime.Caching 4.7.0
- Microsoft.Identity.Client 4.21.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Core 3.1

- Microsoft.Data.SqlClient.SNI.runtime 2.1.1
- Microsoft.Win32.Registry 4.7.0
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Diagnostics.DiagnosticSource 4.7.0
- System.Configuration.ConfigurationManager 4.7.0
- System.Runtime.Caching 4.7.0
- Microsoft.Identity.Client 4.21.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Standard 2.0

- Microsoft.Data.SqlClient.SNI.runtime 2.1.1
- Microsoft.Win32.Registry 4.7.0
- System.Buffers 4.5.1
- System.Memory 4.5.4
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Runtime.Caching 4.7.0
- Microsoft.Identity.Client 4.21.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0

#### .NET Standard 2.1

- Microsoft.Data.SqlClient.SNI.runtime 2.1.1
- Microsoft.Win32.Registry 4.7.0
- System.Buffers 4.5.1
- System.Memory 4.5.4
- System.Security.Principal.Windows 4.7.0
- System.Text.Encoding.CodePages 4.7.0
- System.Runtime.Caching 4.7.0
- Microsoft.Identity.Client 4.21.1
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0
