# Release Notes

## Microsoft.Data.SqlClient 5.0.0-preview1.22069.1 released 9 March 2022

This update brings the below changes over the previous release:

### Contributors
Thanks to the following public contributors. Their efforts toward this project are very much appreciated.
- [Wraith2](https://github.com/Wraith2)
- [EngRajabi](https://github.com/EngRajabi)

### Added

- Added SqlDataSourceEnumerator. [#1430](https://github.com/dotnet/SqlClient/pull/1430), [Read more](#sql-data-source-enumerator-support)
- Added new attestation protocol `None` option to forgo enclave attestation when using VBS enclaves. [#1425](https://github.com/dotnet/SqlClient/pull/1425) and [#1419](https://github.com/dotnet/SqlClient/pull/1419), [Read more](#new-attestation-protocol-none)
- Added a new AppContext switch to suppress insecure TLS warnings. [#1457](https://github.com/dotnet/SqlClient/pull/1457), [Read more](#suppress-insecure-tls-warnings)

### Fixed

- Fixed all documentation paths to Unix format path. [#1442](https://github.com/dotnet/SqlClient/pull/1442)
- Fixed thread safety issue for `GetEnclaveProvider` by converting dictionary to concurrent dictionary. [#1451](https://github.com/dotnet/SqlClient/pull/1451)

### Changed
- Updated `Microsoft.Data.SqlClient.SNI` (.NET Framework dependency) and `Microsoft.Data.SqlClient.SNI.runtime` (.NET Core/Standard dependency) version to `v5.0.0-preview1.22062.1`. [#1537](https://github.com/dotnet/SqlClient/pull/1537)
- Modernized style in ValueUtilSmi. [#1351](https://github.com/dotnet/SqlClient/pull/1351)
- Changed SQL server codenames to version names. [#1439](https://github.com/dotnet/SqlClient/pull/1439)
- Prevented subtype generation in project files. [#1452](https://github.com/dotnet/SqlClient/pull/1452)
- Changed `Array.Copy` to `Buffer.BlockCopy` for byte arrays. [#1366](https://github.com/dotnet/SqlClient/pull/1366)
- Changed files in csproj to be alphabetically sorted in netfx and netcore. [#1364](https://github.com/dotnet/SqlClient/pull/1364)
- Sqlstream, SqlInternalTransaction and MetaDataUtilsSmi are moved to shared folder. [#1337](https://github.com/dotnet/SqlClient/pull/1337), [#1346](https://github.com/dotnet/SqlClient/pull/1346) and [#1339](https://github.com/dotnet/SqlClient/pull/1339)
- Various code improvements: [#1197](https://github.com/dotnet/SqlClient/pull/1197), [#1313](https://github.com/dotnet/SqlClient/pull/1313),[#1330](https://github.com/dotnet/SqlClient/pull/1330),[#1366](https://github.com/dotnet/SqlClient/pull/1366), [#1435](https://github.com/dotnet/SqlClient/pull/1435),[#1478](https://github.com/dotnet/SqlClient/pull/1478)

### SQL Data Source Enumerator support
Provides a mechanism for enumerating all available instances of SQL Server within the local network.
```cs
using Microsoft.Data.Sql;

static void Main()  
  {  
    // Retrieve the enumerator instance and then the data.  
    SqlDataSourceEnumerator instance =  
      SqlDataSourceEnumerator.Instance;  
    System.Data.DataTable table = instance.GetDataSources();  
  
    // Display the contents of the table.  
    DisplayData(table);  
  
    Console.WriteLine("Press any key to continue.");  
    Console.ReadKey();  
  }  
  
  private static void DisplayData(System.Data.DataTable table)  
  {  
    foreach (System.Data.DataRow row in table.Rows)  
    {  
      foreach (System.Data.DataColumn col in table.Columns)  
      {  
        Console.WriteLine("{0} = {1}", col.ColumnName, row[col]);  
      }  
      Console.WriteLine("============================");  
    }  
  }  
```

### New Attestation protocol `None`
 new attestation protocol called `None` will be allowed in the connection string. This protocol will allow users to forgo enclave attestation for `VBS` enclaves. When this protocol is set, the enclave attestation URL property is optional.  

Connection string example:

```cs
//Attestation protocol NONE with no URL
"Data Source = {server}; Initial Catalog = {db}; Column Encryption Setting = Enabled; Attestation Protocol = None;"

```

### Suppress insecure TLS warnings
A security warning is ouptput on the console if the TLS version less than 1.2 is used to negotiate with the server. This warning could be suppressed on SQL connection while `Encrypt = false` by enabling the following AppContext switch on the application startup:
```cs
Switch.Microsoft.Data.SqlClient.SuppressInsecureTLSWarning
```

## Target Platform Support

- .NET Framework 4.6.1+ (Windows x86, Windows x64)
- .NET Core 3.1+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 5.0.0.preview1.22062.1
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Security.Cryptography.Algorithms 4.3.1
- System.Security.Cryptography.Primitives 4.3.0
- System.Text.Encodings.Web 4.7.2

#### .NET Core

- Microsoft.Data.SqlClient.SNI.runtime 5.0.0.preview1.22062.1
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.Diagnostics.DiagnosticSource 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI.runtime 5.0.0.preview1.22062.1
- Azure.Identity 1.3.0
- Microsoft.Identity.Client 4.22.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.8.0
- Microsoft.IdentityModel.JsonWebTokens 6.8.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Resources.ResourceManager 4.3.0
- System.Runtime.Loader 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0