# Release Notes

## Microsoft.Data.SqlClient 5.0.0 released 5 August 2022

This update includes the following changes over the 4.1 release:

### Contributors
Thanks to the following public contributors. Their efforts toward this project are very much appreciated.
- [Wraith2](https://github.com/Wraith2)
- [ErikEJ](https://github.com/ErikEJ)
- [EngRajabi](https://github.com/EngRajabi)
- [tf-micwil](https://github.com/tf-micwil)
- [swh-cb](https://github.com/swh-cb)

### Breaking changes

- As part of the [`TDS 8` feature](#tds-8-enhanced-security), the `SqlConnectionStringBuilder.Encrypt` property has changed from a `bool` to a `SqlConnectionEncryptOption`. `SqlConnectionEncryptOption` has implicit conversion rules to convert to/from a `bool` so that existing code remains backwards compatible, however this is a binary-breaking change and a recompile is required against this version.
- Added a dependency on the [Microsoft.SqlServer.Server](https://github.com/dotnet/SqlClient/tree/main/src/Microsoft.SqlServer.Server) package. This new dependency may cause namespace conflicts if your application references that namespace and still has package references (direct or indirect) to System.Data.SqlClient from .NET Core.
- Dropped classes from the `Microsoft.Data.SqlClient.Server` namespace and replaced them with supported types from the [Microsoft.SqlServer.Server](https://github.com/dotnet/SqlClient/tree/main/src/Microsoft.SqlServer.Server) package.[#1585](https://github.com/dotnet/SqlClient/pull/1585) The affected classes and enums are:
  - Microsoft.Data.SqlClient.Server.IBinarySerialize -> Microsoft.SqlServer.Server.IBinarySerialize
  - Microsoft.Data.SqlClient.Server.InvalidUdtException -> Microsoft.SqlServer.Server.InvalidUdtException
  - Microsoft.Data.SqlClient.Server.SqlFacetAttribute -> Microsoft.SqlServer.Server.SqlFacetAttribute
  - Microsoft.Data.SqlClient.Server.SqlFunctionAttribute -> Microsoft.SqlServer.Server.SqlFunctionAttribute
  - Microsoft.Data.SqlClient.Server.SqlMethodAttribute -> Microsoft.SqlServer.Server.SqlMethodAttribute
  - Microsoft.Data.SqlClient.Server.SqlUserDefinedAggregateAttribute -> Microsoft.SqlServer.Server.SqlUserDefinedAggregateAttribute
  - Microsoft.Data.SqlClient.Server.SqlUserDefinedTypeAttribute -> Microsoft.SqlServer.Server.SqlUserDefinedTypeAttribute
  - (enum) Microsoft.Data.SqlClient.Server.DataAccessKind -> Microsoft.SqlServer.Server.DataAccessKind
  - (enum) Microsoft.Data.SqlClient.Server.Format -> Microsoft.SqlServer.Server.Format
  - (enum) Microsoft.Data.SqlClient.Server.SystemDataAccessKind -> Microsoft.SqlServer.Server.SystemDataAccessKind
- Dropped support for .NET Framework 4.6.1 [#1574](https://github.com/dotnet/SqlClient/pull/1574)


### Added

- Added support for `TDS 8`. To use TDS 8, users should specify Encrypt=Strict in the connection string. [#1608](https://github.com/dotnet/SqlClient/pull/1608) [Read more](#tds-8-enhanced-security)
- Added `TDS 8`  version for TDSLogin. [#1657](https://github.com/dotnet/SqlClient/pull/1657)
- Added support for specifying Server SPN and Failover Server SPN on the connection. [#1607](https://github.com/dotnet/SqlClient/pull/1607) [Read more](#server-spn)
- Added support for aliases when targeting .NET Core on Windows. [#1588](https://github.com/dotnet/SqlClient/pull/1588) [Read more](#support-for-aliases)
- Added support for `SqlDataSourceEnumerator` on Windows. [#1430](https://github.com/dotnet/SqlClient/pull/1430), [Read more](#sql-data-source-enumerator-support)
- Added new attestation protocol `None` option to forgo enclave attestation when using VBS enclaves. [#1425](https://github.com/dotnet/SqlClient/pull/1425) and [#1419](https://github.com/dotnet/SqlClient/pull/1419), [Read more](#new-attestation-protocol-none)
- Added a new AppContext switch to suppress insecure TLS warnings. [#1457](https://github.com/dotnet/SqlClient/pull/1457), [Read more](#suppress-insecure-tls-warnings)

### Fixed

- Fixed null SqlBinary as rowversion. [#1688](https://github.com/dotnet/SqlClient/pull/1688)
- Fixed **KeyNotFoundException** for the `FailoverPartner` key on SQL servers with availability group configured. [#1614](https://github.com/dotnet/SqlClient/pull/1614)
- Fixed naming, order, and formatting for `SqlDiagnosticsListener` on .NET Core and .NET. [#1637](https://github.com/dotnet/SqlClient/pull/1637)
- Fixed NullReferenceException during Azure Active Directory authentication. [#1625](https://github.com/dotnet/SqlClient/pull/1625)
- Added CommandText length validation when using stored procedure command types. [#1484](https://github.com/dotnet/SqlClient/pull/1484)
- Fixed `GetSchema("StructuredTypeMembers")` to return correct schema information. [#1500](https://github.com/dotnet/SqlClient/pull/1500), [#1639](https://github.com/dotnet/SqlClient/pull/1639)
- Fixed **NullReferenceException** when using `SqlDependency.Start` against an Azure SQL Database. [#1294](https://github.com/dotnet/SqlClient/pull/1294)
- Fixed transaction descriptor in the MARS TDS Header when there is no current transaction on .NET 5+ and .NET Core. [#1624](https://github.com/dotnet/SqlClient/pull/1624)
- Parallelize SSRP requests on Linux and macOS when MultiSubNetFailover is specified. [#1578](https://github.com/dotnet/SqlClient/pull/1578)
- Fixed connection failure by skipping Certificate Revocation List (CRL) check during authentication. [#1559](https://github.com/dotnet/SqlClient/pull/1559)
- Fixed thread safety issue for `GetEnclaveProvider` by converting dictionary to concurrent dictionary. [#1451](https://github.com/dotnet/SqlClient/pull/1451)

### Changed

- Updated `AuthProviderInfo` struct to be matched the changes in native SNI for `TDS 8` server certificate validation. [#1680](https://github.com/dotnet/SqlClient/pull/1680)
- Updated default system protocol for `TDS 8` on managed code. [#1678](https://github.com/dotnet/SqlClient/pull/1678)
- Updated `Microsoft.Data.SqlClient.SNI` (.NET Framework dependency) and `Microsoft.Data.SqlClient.SNI.runtime` (.NET Core/Standard dependency) version to `5.0.0`. [#1608](https://github.com/dotnet/SqlClient/pull/1608)
- Changed encoding UTF-7 to ASCII for SSRP Broadcast. [#1671](https://github.com/dotnet/SqlClient/pull/1671)
- Updated `IdentityModel` dependency from 6.8.0 to 6.21.0 and `IdentityClient` from 4.32.2 to 4.45.0. [#1646](https://github.com/dotnet/SqlClient/pull/1646)
- Updated **Azure Identity** dependency from 1.5.0 to 1.6.0. [#1611](https://github.com/dotnet/SqlClient/pull/1611)
- Improved Regex for `SqlCommandSet`. [#1548](https://github.com/dotnet/SqlClient/pull/1548)
- Adjust the default **ConnectRetryCount** against Azure Synapse OnDemand endpoints. [#1626](https://github.com/dotnet/SqlClient/pull/1626)
- Updated `Azure.Identity`  version to `1.5.0` and `Microsoft.Identity.Client` version to `4.30.1`. [#1462](https://github.com/dotnet/SqlClient/pull/1462)
- Replaced `AlwaysEncryptedAttestationException` with `SqlException`. [#1515](https://github.com/dotnet/SqlClient/pull/1515)
- Improved error message when adding wrong type to `SqlParameterCollection`. [#1547](https://github.com/dotnet/SqlClient/pull/1547)
- Changed SQL server codenames to version names in the code. [#1439](https://github.com/dotnet/SqlClient/pull/1439)
- Changed `Array.Copy` to `Buffer.BlockCopy` for byte arrays. [#1366](https://github.com/dotnet/SqlClient/pull/1366)
- Various code improvements: [#1197](https://github.com/dotnet/SqlClient/pull/1197), [#1313](https://github.com/dotnet/SqlClient/pull/1313), [#1330](https://github.com/dotnet/SqlClient/pull/1330), [#1366](https://github.com/dotnet/SqlClient/pull/1366), [#1435](https://github.com/dotnet/SqlClient/pull/1435), [#1478](https://github.com/dotnet/SqlClient/pull/1478), [#1353](https://github.com/dotnet/SqlClient/pull/1353), [#1354](https://github.com/dotnet/SqlClient/pull/1354), [#1525](https://github.com/dotnet/SqlClient/pull/1525), [#1186](https://github.com/dotnet/SqlClient/pull/1186), [#1343](https://github.com/dotnet/SqlClient/pull/1343), [#1370](https://github.com/dotnet/SqlClient/pull/1370), [#1371](https://github.com/dotnet/SqlClient/pull/1371), [#1438](https://github.com/dotnet/SqlClient/pull/1438), [#1483](https://github.com/dotnet/SqlClient/pull/1483), [#1351](https://github.com/dotnet/SqlClient/pull/1351), [#1452](https://github.com/dotnet/SqlClient/pull/1452), [#1364](https://github.com/dotnet/SqlClient/pull/1364),[#1337](https://github.com/dotnet/SqlClient/pull/1337), [#1346](https://github.com/dotnet/SqlClient/pull/1346), [#1339](https://github.com/dotnet/SqlClient/pull/1339), [#1555](https://github.com/dotnet/SqlClient/pull/1555)


### TDS 8 Enhanced Security

To use TDS 8.0, specify Encrypt=Strict in the connection string. Strict mode disables TrustServerCertificate (always treated as False in Strict mode). HostNameInCertificate has been added to help some Strict mode scenarios. TDS 8 begins and continues all server communication inside a secure, encrypted TLS connection.

New Encrypt values have been added to clarify connection encryption behavior. Encrypt=Mandatory is equivalent to Encrypt=True and encrypts connections during the TDS connection negotiation. Encrypt=Optional is equivalent to Encrypt=False and only encrypts the connection if the server tells the client that encryption is required during the TDS connection negotiation.

HostNameInCertificate can be specified in the connection string when using aliases to connect with encryption to a server that has a server certificate with a different name or alternate subject name than the name used by the client to identify the server (DNS aliases, for example). Example usage: HostNameInCertificate=MyDnsAliasName

To read more about TDS 8.0 in SQL Server, see the [SQL Server online documentation](https://docs.microsoft.com/sql/relational-databases/security/networking/tds-8-and-tls-1-3).

### Server SPN

When connecting in an environment that has unique domain/forest topography, the ServerSPN/Server SPN and FailoverServerSPN/Failover Server SPN connection string settings can be used to override the auto-generated server SPNs used in the library when authenticating with integrated authentication in a domain environment.

### Support for Aliases

Users can configure Aliases by using the SQL Server Configuration Manager. These are stored in the Windows registry and are already supported when targeting .NET Framework. This release brings support for aliases when targeting .NET or .NET Core on Windows.


### SQL Data Source Enumerator support
Provides a mechanism for enumerating all available instances of SQL Server within the local network.
```cs
using Microsoft.Data.Sql;

static void Main()  
  {  
    // Retrieve the enumerator instance and then the data.  
    SqlDataSourceEnumerator instance =  
      SqlDataSourceEnumerator.Instance;  
    System.Data.DataTable table = instance.GetDataSources();  
  
    // Display the contents of the table.  
    DisplayData(table);  
  
    Console.WriteLine("Press any key to continue.");  
    Console.ReadKey();  
  }  
  
  private static void DisplayData(System.Data.DataTable table)  
  {  
    foreach (System.Data.DataRow row in table.Rows)  
    {  
      foreach (System.Data.DataColumn col in table.Columns)  
      {  
        Console.WriteLine("{0} = {1}", col.ColumnName, row[col]);  
      }  
      Console.WriteLine("============================");  
    }  
  }  
```

### New Attestation protocol `None`
A new attestation protocol called `None` is allowed in the connection string. This protocol will allow users to forgo enclave attestation for `VBS` enclaves. When this protocol is set, the enclave attestation URL property is optional.  

Connection string example:

```cs
//Attestation protocol NONE with no URL
"Data Source = {server}; Initial Catalog = {db}; Column Encryption Setting = Enabled; Attestation Protocol = None;"

```

### Suppress insecure TLS warnings
A security warning is output to the console if a TLS version less than 1.2 is used to negotiate encryption with the server. This warning can be suppressed on connections where `Encrypt = false` by enabling the following AppContext switch at application startup:
```cs
Switch.Microsoft.Data.SqlClient.SuppressInsecureTLSWarning
```

## Target Platform Support

- .NET Framework 4.6.2+ (Windows x86, Windows x64)
- .NET Core 3.1+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 5.0.0
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Security.Cryptography.Algorithms 4.3.1
- System.Security.Cryptography.Primitives 4.3.0
- System.Text.Encoding.Web 4.7.2

#### .NET Core

- Microsoft.Data.SqlClient.SNI.runtime 5.0.0
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.Diagnostics.DiagnosticSource 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI.runtime 5.0.0
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Runtime.Loader 4.3.0
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0
