# Release Notes

## Microsoft.Data.SqlClient 5.0.1 released 7 October 2022

This update includes the following changes over the 5.0.0 release:

### Contributors
Thanks to the following public contributors. Their efforts toward this project are very much appreciated.

### Fixed

- Fixed missing `HostNameInCertificate` connection string property in .NET Framework. [#1782](https://github.com/dotnet/SqlClient/pull/1782)
- Fixed async deadlock issue when sending attention fails due to network failure. [#1783](https://github.com/dotnet/SqlClient/pull/1783)
- Fixed **Null Reference Exception** on assigning `null` to `SqlConnectionStringBuilder.Encrypt`. [#1784](https://github.com/dotnet/SqlClient/pull/1784)
- Fixed `ReadAsync()` behavior to register Cancellation token action before streaming results. [#1785](https://github.com/dotnet/SqlClient/pull/1785)
- Fixed hang on infinite timeout and managed SNI. [#1798](https://github.com/dotnet/SqlClient/pull/1798)
- Fixed Default UTF8 collation conflict. [#1799](https://github.com/dotnet/SqlClient/pull/1799)

### Changed

- Updated `Microsoft.Data.SqlClient.SNI` (.NET Framework dependency) and `Microsoft.Data.SqlClient.SNI.runtime` (.NET Core/Standard dependency) version to `5.0.1` [#1795](https://github.com/dotnet/SqlClient/pull/1795), which includes the fix for AppDomain crash introducing in issue [#1418](https://github.com/dotnet/SqlClient/issues/1418).

## Target Platform Support

- .NET Framework 4.6.2+ (Windows x86, Windows x64)
- .NET Core 3.1+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 5.0.1
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Security.Cryptography.Algorithms 4.3.1
- System.Security.Cryptography.Primitives 4.3.0
- System.Text.Encoding.Web 4.7.2

#### .NET Core

- Microsoft.Data.SqlClient.SNI.runtime 5.0.1
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.Diagnostics.DiagnosticSource 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI.runtime 5.0.1
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Runtime.Loader 4.3.0
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0
