# Release Notes

## Microsoft.Data.SqlClient 5.0.2 released 31 March 2023

This update includes the following changes over the 5.0.1 release:

### Contributors
Thanks to the following public contributors. Their efforts toward this project are very much appreciated.
- [Wraith2](https://github.com/Wraith2)

### Fixed

- Fixed memory leak regression from [#1785](https://github.com/dotnet/SqlClient/pull/1785) using a `DisposableTemporaryOnStack` struct. [#1980](https://github.com/dotnet/SqlClient/pull/1980)
- Fixed `TransactionScope` connection issue when `Enlist` is `enabled`, `Pooling` is `disabled`, and `Network Connection Type` is set to `Redirect`. [#1978](https://github.com/dotnet/SqlClient/pull/1978)
- Fixed an incorrect exception when a symmetric key fails to decrypt a column using Always Encrypted. [#1977](https://github.com/dotnet/SqlClient/pull/1977)
- Fixed TDS RPC error on large queries in `SqlCommand.ExecuteReaderAsync`. [#1976](https://github.com/dotnet/SqlClient/pull/1976)
- Fixed deadlock when using SinglePhaseCommit with distributed transactions. [#1975](https://github.com/dotnet/SqlClient/pull/1975)

## Target Platform Support

- .NET Framework 4.6.2+ (Windows x86, Windows x64)
- .NET Core 3.1+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 5.0.1
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Security.Cryptography.Algorithms 4.3.1
- System.Security.Cryptography.Primitives 4.3.0
- System.Text.Encoding.Web 4.7.2

#### .NET Core

- Microsoft.Data.SqlClient.SNI.runtime 5.0.1
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.Diagnostics.DiagnosticSource 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI.runtime 5.0.1
- Azure.Identity 1.6.0
- Microsoft.Identity.Client 4.45.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.21.0
- Microsoft.IdentityModel.JsonWebTokens 6.21.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 5.0.0
- System.IO 4.3.0
- System.Runtime.Caching 5.0.0
- System.Text.Encoding.CodePages 5.0.0
- System.Text.Encodings.Web 4.7.2
- System.Runtime.Loader 4.3.0
- System.Resources.ResourceManager 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0
