# Release Notes

## Microsoft.Data.SqlClient 5.1.1 released 28 March 2023

This update includes the following changes over the previous release:

### Contributors
Thanks to the following public contributors. Their efforts toward this project are very much appreciated.

### Fixed

- Fixed an incorrect exception when a symmetric key fails to decrypt a column using Always Encrypted. [#1968](https://github.com/dotnet/SqlClient/pull/1968)
- Fixed `TransactionScope` connection issue when `Enlist` is `enabled`, `Pooling` is `disabled`, and `Network Connection Type` is set to `Redirect`. [#1967](https://github.com/dotnet/SqlClient/pull/1967)
- Fixed throttling of token requests by calling `AcquireTokenSilent`. [#1966](https://github.com/dotnet/SqlClient/pull/1966)
- Fixed TDS RPC error on large queries in `SqlCommand.ExecuteReaderAsync`. [#1965](https://github.com/dotnet/SqlClient/pull/1965)
- Fixed `NullReferenceException` in `GetBytesAsync`. [#1964](https://github.com/dotnet/SqlClient/pull/1964)

## Target Platform Support

- .NET Framework 4.6.2+ (Windows x86, Windows x64)
- .NET 6.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Windows ARM64, Windows ARM, Linux, macOS)

### Dependencies

#### .NET Framework

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.7.0
- Microsoft.Identity.Client 4.47.2
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.Runtime.InteropServices.RuntimeInformation 4.3.0
- System.Text.Encoding.Web 6.0.0

#### .NET

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.7.0
- Microsoft.Identity.Client 4.47.2
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- Microsoft.SqlServer.Server 1.0.0
- System.Configuration.ConfigurationManager 6.0.1
- System.Diagnostics.DiagnosticSource 6.0.0
- System.Runtime.Caching 6.0.0
- System.Text.Encoding.CodePages 6.0.0
- System.Text.Encodings.Web 6.0.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0

#### .NET Standard

- Microsoft.Data.SqlClient.SNI 5.1.0
- Azure.Identity 1.7.0
- Microsoft.Identity.Client 4.47.2
- Microsoft.IdentityModel.Protocols.OpenIdConnect 6.24.0
- Microsoft.IdentityModel.JsonWebTokens 6.24.0
- Microsoft.SqlServer.Server 1.0.0
- Microsoft.Win32.Registry 5.0.0
- System.Buffers 4.5.1
- System.Configuration.ConfigurationManager 6.0.1
- System.Runtime.Caching 6.0.0
- System.Text.Encoding.CodePages 6.0.0
- System.Text.Encodings.Web 6.0.0
- System.Runtime.Loader 4.3.0
- System.Security.Cryptography.Cng 5.0.0
- System.Security.Principal.Windows 5.0.0
